/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

import org.hibernate.AssertionFailure;

public enum AccessType {
    DEFAULT("property"),
    PROPERTY("property"),
    FIELD("field"),
    RECORD("record");

    private final String accessType;

    private AccessType(String type) {
        this.accessType = type;
    }

    public String getType() {
        return this.accessType;
    }

    public static AccessType getAccessStrategy(String externalName) {
        if (externalName == null) {
            return DEFAULT;
        }
        for (AccessType value : AccessType.values()) {
            if (!value.accessType.equals(externalName)) continue;
            return value;
        }
        return DEFAULT;
    }

    public static AccessType getAccessStrategy(jakarta.persistence.AccessType type) {
        if (type == null) {
            return DEFAULT;
        }
        switch (type) {
            case FIELD: {
                return FIELD;
            }
            case PROPERTY: {
                return PROPERTY;
            }
        }
        throw new AssertionFailure("unrecognized AccessType");
    }
}

