/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.text.Normalizer;
import org.wildfly.security.password.Password;

abstract class AbstractPasswordImpl
implements Password {
    private static final long serialVersionUID = -7527865607883174548L;

    AbstractPasswordImpl() {
    }

    abstract <S extends KeySpec> S getKeySpec(Class<S> var1) throws InvalidKeySpecException;

    abstract boolean verify(char[] var1) throws InvalidKeyException;

    boolean verify(char[] guess, Charset hashCharset) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    abstract <T extends KeySpec> boolean convertibleTo(Class<T> var1);

    @Override
    public abstract AbstractPasswordImpl clone();

    Password translate(AlgorithmParameterSpec parameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException();
    }

    static byte[] getNormalizedPasswordBytes(char[] characters) {
        return AbstractPasswordImpl.getNormalizedPasswordBytes(characters, StandardCharsets.UTF_8);
    }

    static byte[] getNormalizedPasswordBytes(char[] characters, Charset charset) {
        return Normalizer.normalize(new String(characters), Normalizer.Form.NFKC).getBytes(charset);
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

