/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.core.instmgr.logging.InstMgrLogger;
import org.wildfly.installationmanager.Repository;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

abstract class InstMgrOperationStepHandler
implements OperationStepHandler {
    protected final InstMgrService imService;
    protected final InstallationManagerFactory imf;

    InstMgrOperationStepHandler(InstMgrService imService, InstallationManagerFactory imf) {
        this.imService = imService;
        this.imf = imf;
    }

    protected void deleteDirIfExits(Path dir, boolean skipRootDir) throws IOException {
        if (dir != null && dir.toFile().exists()) {
            try (Stream<Path> walk = Files.walk(dir, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).filter(f -> !skipRootDir || skipRootDir && !f.equals(dir)).map(Path::toFile).forEach(File::delete);
            }
        }
    }

    protected void deleteDirIfExits(Path dir) throws IOException {
        this.deleteDirIfExits(dir, false);
    }

    protected void unzip(InputStream is, Path targetDir) throws IOException, ZipException {
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                Path current = targetDir.resolve(name);
                if (!current.normalize().startsWith(targetDir.normalize())) {
                    throw InstMgrLogger.ROOT_LOGGER.zipEntryOutsideOfTarget(current.toRealPath(new LinkOption[0]).toString(), targetDir.toRealPath(new LinkOption[0]).toString());
                }
                if (entry.isDirectory()) {
                    current.toFile().mkdirs();
                } else {
                    Files.copy(zis, current, StandardCopyOption.REPLACE_EXISTING);
                }
                entry = zis.getNextEntry();
            }
        }
    }

    protected Path getUploadedMvnRepoRoot(Path source) throws Exception, ZipException {
        try (Stream<Path> content = Files.walk(source, 2, new FileVisitOption[0]);){
            List entries = content.filter(e -> e.toFile().isDirectory() && e.getFileName().toString().equals("maven-repository")).collect(Collectors.toList());
            if (entries.isEmpty() || entries.size() != 1) {
                throw InstMgrLogger.ROOT_LOGGER.invalidZipEntry("maven-repository");
            }
            Path path = (Path)entries.get(0);
            return path;
        }
    }

    protected List<Repository> getRepositoriesFromOperationStreams(OperationContext context, List<ModelNode> mavenRepoFileIndexes, Path workDir) throws OperationFailedException, ExecutionException {
        ArrayList<CompletionStage> futureResults = new ArrayList<CompletionStage>();
        ExecutorService mgmtExecutor = this.imService.getMgmtExecutor();
        for (ModelNode modelNode : mavenRepoFileIndexes) {
            int n = modelNode.asInt();
            CompletableFuture<Path> completableFuture = CompletableFuture.supplyAsync(() -> this.saveMavenZipRepoStream(context, index, workDir, workDir.getFileName().toString()), mgmtExecutor);
            CompletionStage repository = completableFuture.thenCompose(zipPath -> CompletableFuture.supplyAsync(() -> this.createRepoFromZip((Path)zipPath, index, workDir), mgmtExecutor));
            futureResults.add(repository);
        }
        ArrayList<Repository> result = new ArrayList<Repository>();
        try {
            for (CompletableFuture completableFuture : futureResults) {
                result.add((Repository)completableFuture.get());
            }
            return result;
        }
        catch (InterruptedException interruptedException) {
            for (CompletableFuture completableFuture : futureResults) {
                completableFuture.cancel(true);
            }
            Thread.currentThread().interrupt();
            throw InstMgrLogger.ROOT_LOGGER.operationCancelled();
        }
        catch (ExecutionException executionException) {
            for (CompletableFuture completableFuture : futureResults) {
                completableFuture.cancel(true);
            }
            throw executionException;
        }
    }

    private Path saveMavenZipRepoStream(OperationContext context, int index, Path baseWorkDir, String tempFilePrefix) throws RuntimeException {
        Path path;
        block9: {
            InstMgrLogger.ROOT_LOGGER.debug("Storing as Zip file attachment with index=" + index);
            InputStream is = context.getAttachmentStream(index);
            try {
                int bytesRead;
                Path tempFile = Files.createTempFile(baseWorkDir, tempFilePrefix, ".zip", new FileAttribute[0]);
                FileOutputStream outputStream = new FileOutputStream(tempFile.toFile());
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                path = tempFile;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return path;
    }

    private Repository createRepoFromZip(Path sourceFile, int index, Path baseWorkDir) throws RuntimeException {
        try {
            InstMgrLogger.ROOT_LOGGER.debug("Unzipping Zip file stored at " + sourceFile + " which was uploaded from index " + index);
            Path repoIdPath = baseWorkDir.resolve("repo-" + index);
            Files.createDirectory(repoIdPath, new FileAttribute[0]);
            try (FileInputStream fileIs = new FileInputStream(sourceFile.toFile());){
                this.unzip(fileIs, repoIdPath);
            }
            Path uploadedMvnRepoRoot = this.getUploadedMvnRepoRoot(repoIdPath);
            Repository uploadedMavenRepo = new Repository(repoIdPath.getFileName().toString(), uploadedMvnRepoRoot.toUri().toURL().toExternalForm());
            InstMgrLogger.ROOT_LOGGER.debug("Zip file stored at " + sourceFile + " which was uploaded from index " + index + " was unzipped at " + repoIdPath);
            return uploadedMavenRepo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

