/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import org.jgroups.Address;
import org.jgroups.blocks.cs.Client;
import org.jgroups.blocks.cs.NioBaseServer;
import org.jgroups.blocks.cs.NioConnection;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Util;

public class NioClient
extends NioBaseServer
implements Client {
    protected Address remote_addr;
    protected NioConnection conn;

    public NioClient(IpAddress bind_addr, IpAddress server_addr) {
        this(bind_addr != null ? bind_addr.getIpAddress() : null, bind_addr != null ? bind_addr.getPort() : 0, server_addr != null ? server_addr.getIpAddress() : null, server_addr != null ? server_addr.getPort() : 0);
    }

    public NioClient(InetAddress bind_addr, int bind_port, InetAddress server_addr, int server_port) {
        super(new DefaultThreadFactory("nio", false), new DefaultSocketFactory(), 0);
        this.clientBindAddress(bind_addr).clientBindPort(bind_port);
        this.remote_addr = new IpAddress(server_addr, server_port);
    }

    @Override
    public Address remoteAddress() {
        return this.remote_addr;
    }

    public NioClient remoteAddress(IpAddress addr) {
        this.remote_addr = addr;
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.conn != null && this.conn.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.conn != null && this.conn.isConnected();
    }

    @Override
    public void start() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.doStart();
            }
            catch (Exception ex) {
                this.stop();
                throw ex;
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.running.compareAndSet(true, false)) {
            Util.close(this.selector, this.conn);
        }
    }

    @Override
    public void send(Address dest, ByteBuffer data) throws Exception {
        this.send(data);
    }

    @Override
    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        this.send(data, offset, length);
    }

    @Override
    public void send(byte[] data, int offset, int length) throws Exception {
        if (this.conn == null) {
            throw new IllegalStateException("connection to server " + this.remote_addr + " doesn't exist (has start() been called?)");
        }
        this.conn.send(data, offset, length);
    }

    @Override
    public void send(ByteBuffer data) throws Exception {
        if (this.conn == null) {
            throw new IllegalStateException("connection to server " + this.remote_addr + " doesn't exist (has start() been called?)");
        }
        this.conn.send(data);
    }

    @Override
    public String toString() {
        return this.conn == null ? String.format("%s -> %s [not connected]", this.localAddress(), this.remoteAddress()) : String.format("%s", this.conn);
    }

    protected void doStart() throws Exception {
        super.start();
        this.selector = Selector.open();
        this.conn = this.createConnection(this.remote_addr);
        this.conn.connect(this.remote_addr, false);
        this.local_addr = this.conn.localAddress();
        if (this.use_peer_connections) {
            this.conn.sendLocalAddress(this.local_addr);
        }
        this.conn.start();
        this.acceptor = this.factory.newThread(new NioBaseServer.Acceptor(), "NioClient.Acceptor [srv=" + this.remote_addr + "]");
        this.acceptor.setDaemon(true);
        this.acceptor.start();
    }
}

