/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshalling.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WrappedMessageByteBufferMarshaller
implements ByteBufferMarshaller {
    private final ImmutableSerializationContext context;

    public WrappedMessageByteBufferMarshaller(ClassLoader loader) {
        this(WrappedMessageByteBufferMarshaller.createSerializationContext(loader));
    }

    private static ImmutableSerializationContext createSerializationContext(final ClassLoader loader) {
        final SerializationContext context = ProtobufUtil.newSerializationContext();
        WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                for (SerializationContextInitializer initializer : ServiceLoader.load(SerializationContextInitializer.class, loader)) {
                    initializer.registerSchema(context);
                    initializer.registerMarshallers(context);
                }
                return null;
            }
        });
        return context;
    }

    public WrappedMessageByteBufferMarshaller(ImmutableSerializationContext context) {
        this.context = context;
    }

    public boolean isMarshallable(Object object) {
        return this.context.canMarshall(object);
    }

    public Object readFrom(InputStream input) throws IOException {
        return ProtobufUtil.fromWrappedStream((ImmutableSerializationContext)this.context, (InputStream)input);
    }

    public void writeTo(OutputStream output, Object object) throws IOException {
        ProtobufUtil.toWrappedStream((ImmutableSerializationContext)this.context, (OutputStream)output, (Object)object);
    }

    public OptionalInt size(Object object) {
        try {
            return OptionalInt.of(ProtobufUtil.computeWrappedMessageSize((ImmutableSerializationContext)this.context, (Object)object));
        }
        catch (IOException e) {
            return OptionalInt.empty();
        }
    }
}

