/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface OtlpConfig
extends PushRegistryConfig {
    public static final OtlpConfig DEFAULT = key -> null;

    default public String prefix() {
        return "otlp";
    }

    default public String url() {
        return (String)PropertyValidator.getUrlString((MeterRegistryConfig)this, (String)"url").orElse((Object)"http://localhost:4318/v1/metrics");
    }

    default public Map<String, String> resourceAttributes() {
        Map<String, String> env = System.getenv();
        String resourceAttributesConfig = (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"resourceAttributes").orElse((Object)env.get("OTEL_RESOURCE_ATTRIBUTES"));
        String[] splitResourceAttributesString = resourceAttributesConfig == null ? new String[]{} : resourceAttributesConfig.trim().split(",");
        Map<String, String> resourceAttributes = Arrays.stream(splitResourceAttributesString).map(String::trim).filter(keyvalue -> keyvalue.length() > 2 && keyvalue.indexOf(61) > 0).collect(Collectors.toMap(keyvalue -> keyvalue.substring(0, keyvalue.indexOf(61)).trim(), keyvalue -> keyvalue.substring(keyvalue.indexOf(61) + 1).trim()));
        if (env.containsKey("OTEL_SERVICE_NAME") && !resourceAttributes.containsKey("service.name")) {
            resourceAttributes.put("service.name", env.get("OTEL_SERVICE_NAME"));
        }
        return resourceAttributes;
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> PushRegistryConfig.validate((PushRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"url", OtlpConfig::url), MeterRegistryConfigValidator.check((String)"resourceAttributes", OtlpConfig::resourceAttributes)});
    }
}

