/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingClassMapper;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigMappingProvider;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.ConfigValidator;
import io.smallrye.config.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.microprofile.config.inject.ConfigProperties;

public final class ConfigMappings
implements Serializable {
    private static final long serialVersionUID = -7790784345796818526L;
    private final ConfigValidator configValidator;
    private final ConcurrentMap<Class<?>, Map<String, ConfigMappingObject>> mappings;

    ConfigMappings(ConfigValidator configValidator) {
        this.configValidator = configValidator;
        this.mappings = new ConcurrentHashMap();
    }

    public static void registerConfigMappings(SmallRyeConfig config, Set<ConfigClassWithPrefix> configClasses) throws ConfigValidationException {
        if (!configClasses.isEmpty()) {
            Boolean validateUnknown = config.getOptionalValue("smallrye.config.mapping.validate-unknown", Boolean.class).orElse(Boolean.TRUE);
            ConfigMappings.mapConfiguration(config, ConfigMappingProvider.builder().validateUnknown(validateUnknown), configClasses);
        }
    }

    public static void registerConfigProperties(SmallRyeConfig config, Set<ConfigClassWithPrefix> configClasses) throws ConfigValidationException {
        if (!configClasses.isEmpty()) {
            ConfigMappings.mapConfiguration(config, ConfigMappingProvider.builder().validateUnknown(false), configClasses);
        }
    }

    public static Map<String, ConfigMappingInterface.Property> getProperties(ConfigClassWithPrefix configClass) {
        ConfigMappingProvider provider = ConfigMappingProvider.builder().validateUnknown(false).addRoot(configClass.getPrefix(), configClass.getKlass()).build();
        return provider.getProperties();
    }

    public static Set<String> mappedProperties(ConfigClassWithPrefix configClass, Set<String> properties) {
        ConfigMappingProvider provider = ConfigMappingProvider.builder().validateUnknown(false).addRoot(configClass.getPrefix(), configClass.getKlass()).build();
        HashSet<String> mappedProperties = new HashSet<String>();
        for (String property : properties) {
            if (provider.getMatchActions().findRootValue(new NameIterator(property)) == null) continue;
            mappedProperties.add(property);
        }
        return mappedProperties;
    }

    static void mapConfiguration(SmallRyeConfig config, ConfigMappingProvider.Builder builder) throws ConfigValidationException {
        ConfigMappings.mapConfiguration(config, builder, new HashSet<ConfigClassWithPrefix>());
    }

    static void mapConfiguration(SmallRyeConfig config, ConfigMappingProvider.Builder builder, Set<ConfigClassWithPrefix> configClasses) throws ConfigValidationException {
        for (ConfigClassWithPrefix configClass : configClasses) {
            builder.addRoot(configClass.getPrefix(), configClass.getKlass());
        }
        ConfigMappingProvider mappingProvider = builder.build();
        ConfigMappings.mapConfiguration(config, mappingProvider);
    }

    static void mapConfiguration(SmallRyeConfig config, ConfigMappingProvider mappingProvider) {
        ConfigMappingContext mappingContext = mappingProvider.mapConfiguration(config);
        config.getConfigMappings().mappings.putAll(mappingContext.getRootsMap());
    }

    <T> T getConfigMapping(Class<T> type) {
        String prefix = Optional.ofNullable(type.getAnnotation(ConfigMapping.class)).map(ConfigMapping::prefix).orElseGet(() -> Optional.ofNullable(type.getAnnotation(ConfigProperties.class)).map(ConfigProperties::prefix).orElse(""));
        return this.getConfigMapping(type, prefix);
    }

    <T> T getConfigMapping(Class<T> type, String prefix) {
        if (prefix == null) {
            return this.getConfigMapping(type);
        }
        Map mappingsForType = (Map)this.mappings.get(ConfigMappingLoader.getConfigMappingClass(type));
        if (mappingsForType == null) {
            throw ConfigMessages.msg.mappingNotFound(type.getName());
        }
        ConfigMappingObject configMappingObject = (ConfigMappingObject)mappingsForType.get(prefix);
        if (configMappingObject == null) {
            throw ConfigMessages.msg.mappingPrefixNotFound(type.getName(), prefix);
        }
        Object value = configMappingObject;
        if (configMappingObject instanceof ConfigMappingClassMapper) {
            value = ((ConfigMappingClassMapper)((Object)configMappingObject)).map();
        }
        this.configValidator.validateMapping(type, prefix, value);
        return type.cast(value);
    }

    static String getPrefix(Class<?> type) {
        ConfigMapping configMapping = type.getAnnotation(ConfigMapping.class);
        return configMapping != null ? configMapping.prefix() : "";
    }

    public static final class ConfigClassWithPrefix {
        private final Class<?> klass;
        private final String prefix;

        public ConfigClassWithPrefix(Class<?> klass, String prefix) {
            this.klass = klass;
            this.prefix = prefix;
        }

        public Class<?> getKlass() {
            return this.klass;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigClassWithPrefix that = (ConfigClassWithPrefix)o;
            return this.klass.equals(that.klass) && this.prefix.equals(that.prefix);
        }

        public int hashCode() {
            return Objects.hash(this.klass, this.prefix);
        }

        public static ConfigClassWithPrefix configClassWithPrefix(Class<?> klass, String prefix) {
            return new ConfigClassWithPrefix(klass, prefix);
        }

        public static ConfigClassWithPrefix configClassWithPrefix(Class<?> klass) {
            return ConfigClassWithPrefix.configClassWithPrefix(klass, ConfigMappings.getPrefix(klass));
        }
    }
}

