/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, SqlClientAttributesGetter<REQUEST>> {
    private final AttributeKey<String> dbTableAttribute;
    private final SqlStatementSanitizer sanitizer;

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientAttributesExtractorBuilder(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST> getter, AttributeKey<String> dbTableAttribute, SqlStatementSanitizer sanitizer) {
        super(getter);
        this.dbTableAttribute = dbTableAttribute;
        this.sanitizer = sanitizer;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        SqlStatementInfo sanitizedStatement = this.sanitizer.sanitize(((SqlClientAttributesGetter)this.getter).rawStatement(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.DB_STATEMENT, (Object)sanitizedStatement.getFullStatement());
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.DB_OPERATION, (Object)sanitizedStatement.getOperation());
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, this.dbTableAttribute, (Object)sanitizedStatement.getTable());
    }
}

