/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.el.expressly.lang;

import jakarta.el.ValueExpression;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.glassfish.expressly.lang.VariableMapperImpl;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.SimpleObjectOutput;

public class VariableMapperImplMarshaller
implements ProtoStreamMarshaller<VariableMapperImpl> {
    private static final int VARIABLE_INDEX = 1;
    private static final int EXPRESSION_INDEX = 2;

    public Class<? extends VariableMapperImpl> getJavaClass() {
        return VariableMapperImpl.class;
    }

    public VariableMapperImpl readFrom(ProtoStreamReader reader) throws IOException {
        LinkedList<String> variables = new LinkedList<String>();
        LinkedList<ValueExpression> expressions = new LinkedList<ValueExpression>();
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    variables.add(reader.readString());
                    continue block4;
                }
                case 2: {
                    expressions.add((ValueExpression)reader.readAny(ValueExpression.class));
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        VariableMapperImpl mapper = new VariableMapperImpl();
        Iterator variableIterator = variables.iterator();
        Iterator expressionIterator = expressions.iterator();
        while (variableIterator.hasNext() && expressionIterator.hasNext()) {
            String variable = (String)variableIterator.next();
            ValueExpression expression = (ValueExpression)expressionIterator.next();
            mapper.setVariable(variable, expression);
        }
        return mapper;
    }

    public void writeTo(ProtoStreamWriter writer, VariableMapperImpl value) throws IOException {
        Object[] objects = new Object[1];
        value.writeExternal(new SimpleObjectOutput.Builder().with(objects).build());
        Map expressions = (Map)objects[0];
        if (expressions != null) {
            for (Map.Entry entry : expressions.entrySet()) {
                writer.writeString(1, (String)entry.getKey());
                writer.writeAny(2, entry.getValue());
            }
        }
    }
}

