/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContext;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContextInitializerProvider;
import org.wildfly.clustering.marshalling.protostream.LangSerializationContextInitializer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SerializationContextBuilder {
    private static final String PROTOSTREAM_BASE_PACKAGE_NAME = BaseMarshaller.class.getPackage().getName();
    private final DefaultSerializationContext context = new DefaultSerializationContext();

    public SerializationContextBuilder(ClassLoaderMarshaller marshaller) {
        this.register(Collections.singleton(new LangSerializationContextInitializer(marshaller)));
        this.register(EnumSet.allOf(DefaultSerializationContextInitializerProvider.class));
    }

    public ImmutableSerializationContext build() {
        return this.context.get();
    }

    public SerializationContextBuilder register(SerializationContextInitializer initializer) {
        this.init(initializer);
        return this;
    }

    public SerializationContextBuilder register(Iterable<? extends SerializationContextInitializer> initializers) {
        for (SerializationContextInitializer serializationContextInitializer : initializers) {
            this.init(serializationContextInitializer);
        }
        return this;
    }

    public SerializationContextBuilder load(ClassLoader loader) {
        this.tryLoad(loader);
        return this;
    }

    public SerializationContextBuilder require(ClassLoader loader) {
        if (!this.tryLoad(loader)) {
            throw new NoSuchElementException();
        }
        return this;
    }

    private boolean tryLoad(final ClassLoader loader) {
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Iterator<SerializationContextInitializer> initializers = ServiceLoader.load(SerializationContextInitializer.class, loader).iterator();
                boolean init = false;
                while (initializers.hasNext()) {
                    SerializationContextInitializer initializer = initializers.next();
                    if (initializer.getClass().getName().startsWith(PROTOSTREAM_BASE_PACKAGE_NAME)) continue;
                    SerializationContextBuilder.this.init(initializer);
                    init = true;
                }
                return init;
            }
        };
        return (Boolean)WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
    }

    void init(SerializationContextInitializer initializer) {
        initializer.registerSchema((SerializationContext)this.context);
        initializer.registerMarshallers((SerializationContext)this.context);
    }
}

