/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.GenericModelDescribeOperationHandler;
import org.jboss.as.domain.controller.resources.DomainResolver;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ProfileCloneHandler
implements OperationStepHandler {
    private static final AttributeDefinition TO_PROFILE = SimpleAttributeDefinitionBuilder.create((String)"to-profile", (ModelType)ModelType.STRING).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("clone", DomainResolver.getResolver("profile", false)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG).addParameter(TO_PROFILE).build();
    private final LocalHostControllerInfo hostInfo;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;

    public ProfileCloneHandler(LocalHostControllerInfo hostInfo, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry) {
        this.hostInfo = hostInfo;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String profileName = context.getCurrentAddressValue();
        final String newProfile = TO_PROFILE.resolveModelAttribute(context, operation).asString();
        String operationName = GenericModelDescribeOperationHandler.DEFINITION.getName();
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile", (String)profileName)});
        PathAddress newPA = PathAddress.pathAddress((String)"profile", (String)newProfile);
        if (!this.hostInfo.isMasterDomainController()) {
            if (this.ignoredDomainResourceRegistry.isResourceExcluded(address) || this.ignoredDomainResourceRegistry.isResourceExcluded(newPA)) {
                return;
            }
            if (this.hostInfo.isRemoteDomainControllerIgnoreUnaffectedConfiguration()) {
                return;
            }
        }
        ModelNode describeOp = new ModelNode();
        describeOp.get("operation").set(operationName);
        describeOp.get("address").set(address.toModelNode());
        final ModelNode result = new ModelNode();
        OperationStepHandler handler = context.getRootResourceRegistration().getOperationHandler(address, operationName);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress newPA = PathAddress.pathAddress((String)"profile", (String)newProfile);
                ArrayList operations = new ArrayList(result.get("result").asList());
                LinkedHashMap<String, ArrayList<ModelNode>> opsBySubsystem = new LinkedHashMap<String, ArrayList<ModelNode>>();
                ModelNode profileAdd = null;
                for (ModelNode op : operations) {
                    PathAddress addr = PathAddress.pathAddress((ModelNode)op.require("address")).subAddress(1);
                    PathAddress a = newPA.append(addr);
                    op.get("address").set(a.toModelNode());
                    if (addr.size() == 0) {
                        profileAdd = op;
                        continue;
                    }
                    String subsystem = addr.getElement(0).getValue();
                    ArrayList<ModelNode> subsystemOps = (ArrayList<ModelNode>)opsBySubsystem.get(subsystem);
                    if (subsystemOps == null) {
                        subsystemOps = new ArrayList<ModelNode>();
                        opsBySubsystem.put(subsystem, subsystemOps);
                    }
                    subsystemOps.add(op);
                }
                for (List ops : opsBySubsystem.values()) {
                    Collections.reverse(ops);
                    for (ModelNode op : ops) {
                        ProfileCloneHandler.this.addOperation(context, op);
                    }
                }
                ProfileCloneHandler.this.addOperation(context, profileAdd);
            }
        }, OperationContext.Stage.MODEL, true);
        context.addStep(result, describeOp, handler, OperationContext.Stage.MODEL, true);
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.hasFailureDescription()) {
                    context.getFailureDescription().set(result.get("failure-description"));
                }
            }
        });
    }

    private void addOperation(OperationContext context, ModelNode op) {
        PathAddress addr = PathAddress.pathAddress((ModelNode)op.require("address"));
        OperationStepHandler h = context.getRootResourceRegistration().getOperationHandler(addr, op.get("operation").asString());
        context.addStep(op, h, OperationContext.Stage.MODEL, true);
    }
}

