/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.buffers.impl.ChannelBufferWrapper;

public final class HornetQBuffers {
    public static HornetQBuffer dynamicBuffer(int size) {
        return new ChannelBufferWrapper(Unpooled.buffer((int)size));
    }

    public static HornetQBuffer dynamicBuffer(byte[] bytes) {
        HornetQBuffer buff = HornetQBuffers.dynamicBuffer(bytes.length);
        buff.writeBytes(bytes);
        return buff;
    }

    public static HornetQBuffer wrappedBuffer(ByteBuffer underlying) {
        ChannelBufferWrapper buff = new ChannelBufferWrapper(Unpooled.wrappedBuffer((ByteBuffer)underlying));
        buff.clear();
        return buff;
    }

    public static HornetQBuffer wrappedBuffer(byte[] underlying) {
        return new ChannelBufferWrapper(Unpooled.wrappedBuffer((byte[])underlying));
    }

    public static HornetQBuffer fixedBuffer(int size) {
        return new ChannelBufferWrapper(Unpooled.buffer((int)size, (int)size));
    }

    private HornetQBuffers() {
    }
}

