/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.Metric;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.PartitionExecutionImpl;

public final class StepExecutionImpl
extends AbstractStepExecution {
    private static final long serialVersionUID = 1L;
    private transient List<PartitionExecutionImpl> partitionExecutions = new ArrayList<PartitionExecutionImpl>();

    public StepExecutionImpl(String stepName) {
        super(stepName);
    }

    public StepExecutionImpl(long id, String stepName, Date startTime, Date endTime, String batchStatus, String exitStatus, Serializable persistentUserData, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Serializable readerCheckpointInfo, Serializable writerCheckpointInfo) {
        super(id, stepName, persistentUserData, readerCheckpointInfo, writerCheckpointInfo);
        if (startTime != null) {
            this.startTime = startTime.getTime();
        }
        if (endTime != null) {
            this.endTime = endTime.getTime();
        }
        this.batchStatus = Enum.valueOf(BatchStatus.class, batchStatus);
        this.exitStatus = exitStatus;
        this.stepMetrics.set(Metric.MetricType.READ_COUNT, readCount);
        this.stepMetrics.set(Metric.MetricType.WRITE_COUNT, writeCount);
        this.stepMetrics.set(Metric.MetricType.COMMIT_COUNT, commitCount);
        this.stepMetrics.set(Metric.MetricType.ROLLBACK_COUNT, rollbackCount);
        this.stepMetrics.set(Metric.MetricType.READ_SKIP_COUNT, readSkipCount);
        this.stepMetrics.set(Metric.MetricType.PROCESS_SKIP_COUNT, processSkipCount);
        this.stepMetrics.set(Metric.MetricType.FILTER_COUNT, filterCount);
        this.stepMetrics.set(Metric.MetricType.WRITE_SKIP_COUNT, writeSkipCount);
    }

    @Override
    public List<PartitionExecutionImpl> getPartitionExecutions() {
        return this.partitionExecutions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StepExecutionImpl that = (StepExecutionImpl)o;
        return this.partitionExecutions.equals(that.partitionExecutions);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.partitionExecutions == null ? 0 : this.partitionExecutions.hashCode());
        return result;
    }
}

