/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.AbstractMap;
import java.util.Map;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.ImmutableSessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.ImmutableSessionFactory;
import org.wildfly.clustering.web.cache.session.ImmutableSessionMetaDataFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class CompositeImmutableSessionFactory<V, L>
implements ImmutableSessionFactory<CompositeSessionMetaDataEntry<L>, V> {
    private final ImmutableSessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> metaDataFactory;
    private final ImmutableSessionAttributesFactory<V> attributesFactory;

    public CompositeImmutableSessionFactory(ImmutableSessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> metaDataFactory, ImmutableSessionAttributesFactory<V> attributesFactory) {
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
    }

    public Map.Entry<CompositeSessionMetaDataEntry<L>, V> findValue(String id) {
        Object attributesValue;
        CompositeSessionMetaDataEntry metaDataValue = (CompositeSessionMetaDataEntry)this.metaDataFactory.findValue(id);
        if (metaDataValue != null && (attributesValue = this.attributesFactory.findValue(id)) != null) {
            return new AbstractMap.SimpleImmutableEntry<CompositeSessionMetaDataEntry, Object>(metaDataValue, attributesValue);
        }
        return null;
    }

    public Map.Entry<CompositeSessionMetaDataEntry<L>, V> tryValue(String id) {
        Object attributesValue;
        CompositeSessionMetaDataEntry metaDataValue = (CompositeSessionMetaDataEntry)this.metaDataFactory.tryValue(id);
        if (metaDataValue != null && (attributesValue = this.attributesFactory.tryValue(id)) != null) {
            return new AbstractMap.SimpleImmutableEntry<CompositeSessionMetaDataEntry, Object>(metaDataValue, attributesValue);
        }
        return null;
    }

    @Override
    public ImmutableSessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> getMetaDataFactory() {
        return this.metaDataFactory;
    }

    @Override
    public ImmutableSessionAttributesFactory<V> getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public ImmutableSession createImmutableSession(String id, ImmutableSessionMetaData metaData, ImmutableSessionAttributes attributes) {
        return new CompositeImmutableSession(id, metaData, attributes);
    }
}

