/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import jakarta.batch.operations.JobOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ContextClassLoaderJobOperatorContextSelector;
import org.jberet.spi.JobOperatorContext;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.batch.jberet.BatchServiceNames;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.deployment.ArtifactFactoryService;
import org.wildfly.extension.batch.jberet.deployment.BatchAttachments;
import org.wildfly.extension.batch.jberet.deployment.BatchEnvironmentMetaData;
import org.wildfly.extension.batch.jberet.deployment.BatchEnvironmentService;
import org.wildfly.extension.batch.jberet.deployment.JobOperatorService;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobXmlResolver;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryService;

public class BatchEnvironmentProcessor
implements DeploymentUnitProcessor {
    private final boolean rcPresent;
    private final ContextClassLoaderJobOperatorContextSelector selector;

    public BatchEnvironmentProcessor(boolean rcPresent, ContextClassLoaderJobOperatorContextSelector selector) {
        this.rcPresent = rcPresent;
        this.selector = selector;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(org.jboss.as.server.deployment.Attachments.MODULE)) {
            WeldCapability api;
            DeploymentUnit parent;
            BatchLogger.LOGGER.tracef("Processing deployment '%s' for the batch environment.", deploymentUnit.getName());
            WildFlyJobXmlResolver jobXmlResolver = WildFlyJobXmlResolver.forDeployment(deploymentUnit);
            if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
                return;
            }
            Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            ModuleClassLoader moduleClassLoader = module.getClassLoader();
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            BatchEnvironmentMetaData metaData = (BatchEnvironmentMetaData)deploymentUnit.getAttachment(BatchAttachments.BATCH_ENVIRONMENT_META_DATA);
            if (metaData == null && (parent = deploymentUnit.getParent()) != null) {
                metaData = (BatchEnvironmentMetaData)parent.getAttachment(BatchAttachments.BATCH_ENVIRONMENT_META_DATA);
            }
            JobRepository jobRepository = metaData != null ? metaData.getJobRepository() : null;
            String jobRepositoryName = metaData != null ? metaData.getJobRepositoryName() : null;
            String dataSourceName = metaData != null ? metaData.getDataSourceName() : null;
            String jobExecutorName = metaData != null ? metaData.getExecutorName() : null;
            Boolean restartJobsOnResume = metaData != null ? metaData.getRestartJobsOnResume() : null;
            Integer executionRecordsLimit = metaData != null ? metaData.getExecutionRecordsLimit() : null;
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
            String deploymentName = deploymentUnit.getName();
            EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            InjectedEENamespaceContextSelector namespaceContextSelector = eeModuleDescription == null ? null : eeModuleDescription.getNamespaceContextSelector();
            ServiceName batchEnvSN = BatchServiceNames.batchEnvironmentServiceName(deploymentUnit);
            ServiceBuilder serviceBuilder = serviceTarget.addService(batchEnvSN);
            Consumer batchEnvironmentConsumer = serviceBuilder.provides(new ServiceName[]{batchEnvSN});
            Supplier jobExecutorSupplier = jobExecutorName != null ? serviceBuilder.requires(Capabilities.THREAD_POOL_CAPABILITY.getCapabilityServiceName(new String[]{jobExecutorName})) : null;
            Supplier batchConfigurationSupplier = serviceBuilder.requires(Capabilities.BATCH_CONFIGURATION_CAPABILITY.getCapabilityServiceName());
            serviceBuilder.requires(support.getCapabilityServiceName("org.wildfly.transactions.global-default-local-provider"));
            ServiceName artifactFactoryServiceName = BatchServiceNames.batchArtifactFactoryServiceName(deploymentUnit);
            ServiceBuilder artifactFactoryServiceBuilder = serviceTarget.addService(artifactFactoryServiceName);
            Consumer artifactFactoryConsumer = artifactFactoryServiceBuilder.provides(new ServiceName[]{artifactFactoryServiceName});
            Supplier beanManagerSupplier = null;
            if (support.hasCapability("org.wildfly.weld") && (api = (WeldCapability)support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class).get()).isPartOfWeldDeployment(deploymentUnit)) {
                BatchLogger.LOGGER.tracef("Adding BeanManager service dependency for deployment %s", deploymentUnit.getName());
                beanManagerSupplier = api.addBeanManagerService(deploymentUnit, artifactFactoryServiceBuilder);
            }
            ArtifactFactoryService artifactFactoryService = new ArtifactFactoryService(artifactFactoryConsumer, beanManagerSupplier);
            artifactFactoryServiceBuilder.setInstance((Service)artifactFactoryService);
            artifactFactoryServiceBuilder.install();
            Supplier artifactFactorySupplier = serviceBuilder.requires(artifactFactoryServiceName);
            Supplier jobRepositorySupplier = null;
            if (jobRepositoryName != null) {
                jobRepositorySupplier = serviceBuilder.requires(support.getCapabilityServiceName(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), new String[]{jobRepositoryName}));
            } else if (dataSourceName != null) {
                ServiceName jobRepositoryServiceName = support.getCapabilityServiceName(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), new String[]{deploymentName});
                ServiceBuilder jobRepositoryServiceBuilder = serviceTarget.addService(jobRepositoryServiceName);
                Consumer jobRepositoryConsumer = jobRepositoryServiceBuilder.provides(new ServiceName[]{jobRepositoryServiceName});
                Supplier executorSupplier = Services.requireServerExecutor((ServiceBuilder)jobRepositoryServiceBuilder);
                Supplier dataSourceSupplier = jobRepositoryServiceBuilder.requires(support.getCapabilityServiceName("org.wildfly.data-source", new String[]{dataSourceName}));
                JdbcJobRepositoryService jdbcJobRepositoryService = new JdbcJobRepositoryService(jobRepositoryConsumer, dataSourceSupplier, executorSupplier, executionRecordsLimit);
                jobRepositoryServiceBuilder.setInstance((Service)jdbcJobRepositoryService);
                jobRepositoryServiceBuilder.install();
                jobRepositorySupplier = serviceBuilder.requires(jobRepositoryServiceName);
            } else if (jobRepository != null) {
                jobRepositorySupplier = () -> jobRepository;
            }
            Supplier requestControllerSupplier = this.rcPresent ? serviceBuilder.requires(BatchServiceNames.requestControllerServiceName(support)) : null;
            BatchEnvironmentService service = new BatchEnvironmentService(batchEnvironmentConsumer, artifactFactorySupplier, jobExecutorSupplier, requestControllerSupplier, jobRepositorySupplier, batchConfigurationSupplier, (ClassLoader)moduleClassLoader, jobXmlResolver, deploymentName, (NamespaceContextSelector)namespaceContextSelector);
            serviceBuilder.setInstance((Service)service);
            serviceBuilder.install();
            ServiceName jobOperatorServiceName = BatchServiceNames.jobOperatorServiceName(deploymentUnit);
            ServiceBuilder jobOperatorServiceSB = serviceTarget.addService(jobOperatorServiceName);
            Consumer jobOperatorConsumer = jobOperatorServiceSB.provides(new ServiceName[]{jobOperatorServiceName});
            Supplier executorSupplier = Services.requireServerExecutor((ServiceBuilder)jobOperatorServiceSB);
            Supplier batchConfigSupplier = jobOperatorServiceSB.requires(support.getCapabilityServiceName(Capabilities.BATCH_CONFIGURATION_CAPABILITY.getName()));
            Supplier suspendControllerSupplier = jobOperatorServiceSB.requires(support.getCapabilityServiceName("org.wildfly.server.suspend-controller"));
            Supplier processStateSupplier = jobOperatorServiceSB.requires(support.getCapabilityServiceName("org.wildfly.management.process-state-notifier"));
            Supplier batchEnvironmentSupplier = jobOperatorServiceSB.requires(BatchServiceNames.batchEnvironmentServiceName(deploymentUnit));
            JobOperatorService jobOperatorService = new JobOperatorService(jobOperatorConsumer, batchConfigSupplier, batchEnvironmentSupplier, executorSupplier, suspendControllerSupplier, processStateSupplier, restartJobsOnResume, deploymentName, jobXmlResolver);
            jobOperatorServiceSB.setInstance((Service)jobOperatorService);
            jobOperatorServiceSB.install();
            deploymentUnit.putAttachment(BatchAttachments.JOB_OPERATOR, (Object)jobOperatorService);
            deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_COMPLETE_SERVICES, (Object)jobOperatorServiceName);
            this.selector.registerContext((ClassLoader)moduleClassLoader, JobOperatorContext.create((JobOperator)jobOperatorService));
        }
    }

    public void undeploy(DeploymentUnit context) {
        if (context.hasAttachment(org.jboss.as.server.deployment.Attachments.MODULE)) {
            this.selector.unregisterContext((ClassLoader)((Module)context.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE)).getClassLoader());
        }
    }
}

