/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.internal;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import org.jboss.narayana.compensations.api.Compensatable;
import org.jboss.narayana.compensations.api.CompensationManager;
import org.jboss.narayana.compensations.internal.BAController;
import org.jboss.narayana.compensations.internal.BAControllerFactory;

public class CompensationInterceptorBase {
    @Inject
    CompensationManager compensationManager;
    @Inject
    BeanManager beanManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InvocationContext ic) throws Exception {
        Compensatable compensatable = this.getCompensatable(ic);
        BAController baController = compensatable.distributed() ? BAControllerFactory.getRemoteInstance() : BAControllerFactory.getLocalInstance();
        baController.beginBusinessActivity();
        Object result = null;
        boolean isException = false;
        try {
            result = ic.proceed();
        }
        catch (Exception e) {
            isException = true;
            this.handleException(ic, e, true);
        }
        finally {
            baController.completeBusinessActivity(isException);
        }
        return result;
    }

    protected Object invokeInCallerTx(InvocationContext ic) throws Exception {
        Object result = null;
        try {
            result = ic.proceed();
        }
        catch (Exception e) {
            this.handleException(ic, e, false);
        }
        return result;
    }

    protected Object invokeInNoTx(InvocationContext ic) throws Exception {
        return ic.proceed();
    }

    private void handleException(InvocationContext ic, Exception exception, boolean started) throws Exception {
        Compensatable compensatable = this.getCompensatable(ic);
        if (this.isDontCancelOn(compensatable, exception)) {
            throw exception;
        }
        if (this.isCancelOn(compensatable, exception) || exception instanceof RuntimeException) {
            this.compensationManager.setCompensateOnly();
        }
        throw exception;
    }

    private boolean isDontCancelOn(Compensatable compensatable, Exception exception) {
        for (Class dontCancelOnClass : compensatable.dontCancelOn()) {
            if (!dontCancelOnClass.isAssignableFrom(exception.getClass())) continue;
            return true;
        }
        return false;
    }

    private boolean isCancelOn(Compensatable compensatable, Exception exception) {
        for (Class cancelOnClass : compensatable.cancelOn()) {
            if (!cancelOnClass.isAssignableFrom(exception.getClass())) continue;
            return true;
        }
        return false;
    }

    private Compensatable getCompensatable(InvocationContext ic) {
        Compensatable compensatable = ic.getMethod().getAnnotation(Compensatable.class);
        if (compensatable != null) {
            return compensatable;
        }
        Class<?> targetClass = ic.getTarget().getClass();
        compensatable = targetClass.getAnnotation(Compensatable.class);
        if (compensatable != null) {
            return compensatable;
        }
        for (Annotation annotation : ic.getMethod().getDeclaringClass().getAnnotations()) {
            if (!this.beanManager.isStereotype(annotation.annotationType())) continue;
            for (Annotation stereotyped : this.beanManager.getStereotypeDefinition(annotation.annotationType())) {
                if (!stereotyped.annotationType().equals(Compensatable.class)) continue;
                return (Compensatable)stereotyped;
            }
        }
        throw new RuntimeException("Expected an @Compensatable annotation at class and/or method level");
    }
}

