/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import org.apache.http.HttpResponse;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.protocol.HttpContext;

final class CustomConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    private final long maxKeepAlive;

    CustomConnectionKeepAliveStrategy(long maxKeepAlive) {
        this.maxKeepAlive = maxKeepAlive;
    }

    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        long keepAliveDuration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
        if (keepAliveDuration > 0L && keepAliveDuration < this.maxKeepAlive) {
            return keepAliveDuration;
        }
        return this.maxKeepAlive;
    }
}

