/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchGeoPointFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.AbstractElasticsearchDocumentValueSort;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDistanceSort
extends AbstractElasticsearchDocumentValueSort {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonObjectAccessor GEO_DISTANCE_ACCESSOR = JsonAccessor.root().property("_geo_distance").asObject();
    private final GeoPoint center;

    private ElasticsearchDistanceSort(Builder builder) {
        super(builder);
        this.center = builder.center;
    }

    @Override
    protected void doToJsonSorts(ElasticsearchSearchSortCollector collector, JsonObject innerObject) {
        innerObject.add(this.absoluteFieldPath, ElasticsearchGeoPointFieldCodec.INSTANCE.encode(this.center));
        this.searchSyntax.requestGeoDistanceSortIgnoreUnmapped(innerObject);
        JsonObject outerObject = new JsonObject();
        GEO_DISTANCE_ACCESSOR.set(outerObject, innerObject);
        collector.collectDistanceSort((JsonElement)outerObject, this.absoluteFieldPath, this.center);
    }

    private static class Builder
    extends AbstractElasticsearchDocumentValueSort.AbstractBuilder<GeoPoint>
    implements DistanceSortBuilder {
        private GeoPoint center;
        private boolean missingFirst = false;
        private boolean missingLast = false;

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<GeoPoint> field) {
            super(scope, field);
        }

        public void center(GeoPoint center) {
            this.center = center;
        }

        public void missingFirst() {
            this.missingFirst = true;
        }

        public void missingLast() {
            this.missingLast = true;
        }

        public void missingHighest() {
        }

        public void missingLowest() {
            throw SortOrder.DESC.equals((Object)this.order) ? log.missingLowestOnDescSortNotSupported(this.field.eventContext()) : log.missingLowestOnAscSortNotSupported(this.field.eventContext());
        }

        public void missingAs(GeoPoint value) {
            throw log.missingAsOnSortNotSupported(this.field.eventContext());
        }

        @Override
        public void mode(SortMode mode) {
            switch (mode) {
                case MIN: 
                case MAX: 
                case AVG: 
                case MEDIAN: {
                    super.mode(mode);
                    break;
                }
                default: {
                    throw log.invalidSortModeForDistanceSort(mode, this.field.eventContext());
                }
            }
        }

        public SearchSort build() {
            if (this.missingFirst && (this.order == null || SortOrder.ASC.equals((Object)this.order))) {
                throw log.missingFirstOnAscSortNotSupported(this.field.eventContext());
            }
            if (this.missingLast && SortOrder.DESC.equals((Object)this.order)) {
                throw log.missingLastOnDescSortNotSupported(this.field.eventContext());
            }
            return new ElasticsearchDistanceSort(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchValueFieldSearchQueryElementFactory<DistanceSortBuilder, GeoPoint> {
        @Override
        public DistanceSortBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<GeoPoint> field) {
            return new Builder(scope, field);
        }
    }
}

