/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.converter.CoreAmqpConverter;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPResourceLimitExceededException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpJmsSelectorFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpNoLocalFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.activemq.artemis.protocol.amqp.proton.transaction.ProtonTransactionImpl;
import org.apache.activemq.artemis.protocol.amqp.util.NettyReadable;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.DestinationUtil;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;
import org.jboss.logging.Logger;

public class ProtonServerSenderContext
extends ProtonInitializable
implements ProtonDeliveryHandler {
    private static final Logger log = Logger.getLogger(ProtonServerSenderContext.class);
    private static final Symbol COPY = Symbol.valueOf((String)"copy");
    private static final Symbol TOPIC = Symbol.valueOf((String)"topic");
    private static final Symbol QUEUE = Symbol.valueOf((String)"queue");
    private static final Symbol SHARED = Symbol.valueOf((String)"shared");
    private static final Symbol GLOBAL = Symbol.valueOf((String)"global");
    SenderController controller;
    private final ConnectionFlushIOCallback connectionFlusher = new ConnectionFlushIOCallback();
    private Consumer brokerConsumer;
    private ReadyListener onflowControlReady;
    protected final AMQPSessionContext protonSession;
    protected final Sender sender;
    protected final AMQPConnectionContext connection;
    protected boolean closed = false;
    protected final AMQPSessionCallback sessionSPI;
    private boolean preSettle;
    private final AtomicBoolean draining = new AtomicBoolean(false);
    volatile boolean hasLarge = false;
    volatile LargeMessageDeliveryContext pendingLargeMessage = null;
    private int credits = 0;
    private AtomicInteger pending = new AtomicInteger(0);
    private final Object creditsLock = new Object();
    private final java.util.function.Consumer<? super MessageReference> executeDelivery;
    private java.util.function.Consumer<? super MessageReference> beforeDelivery;
    private final boolean amqpTreatRejectAsUnmodifiedDeliveryFailed;

    public ProtonServerSenderContext(AMQPConnectionContext connection, Sender sender, AMQPSessionContext protonSession, AMQPSessionCallback server) {
        this(connection, sender, protonSession, server, null);
    }

    public ProtonServerSenderContext(AMQPConnectionContext connection, Sender sender, AMQPSessionContext protonSession, AMQPSessionCallback server, SenderController senderController) {
        this.controller = senderController;
        this.connection = connection;
        this.sender = sender;
        this.protonSession = protonSession;
        this.sessionSPI = server;
        this.executeDelivery = this::executeDelivery;
        this.amqpTreatRejectAsUnmodifiedDeliveryFailed = this.connection.getProtocolManager().isAmqpTreatRejectAsUnmodifiedDeliveryFailed();
    }

    public ProtonServerSenderContext setBeforeDelivery(java.util.function.Consumer<? super MessageReference> beforeDelivery) {
        this.beforeDelivery = beforeDelivery;
        return this;
    }

    public Object getBrokerConsumer() {
        return this.brokerConsumer;
    }

    @Override
    public void onFlow(int currentCredits, boolean drain) {
        this.connection.requireInHandler();
        this.setupCredit();
        ServerConsumerImpl serverConsumer = (ServerConsumerImpl)this.brokerConsumer;
        if (drain) {
            if (this.draining.compareAndSet(false, true)) {
                final ProtonServerSenderContext plugSender = (ProtonServerSenderContext)serverConsumer.getProtocolContext();
                serverConsumer.forceDelivery(1L, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProtonServerSenderContext.this.connection.runNow(() -> {
                                plugSender.reportDrained();
                                ProtonServerSenderContext.this.setupCredit();
                            });
                        }
                        finally {
                            ProtonServerSenderContext.this.draining.set(false);
                        }
                    }
                });
            }
        } else {
            serverConsumer.receiveCredits(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCredits() {
        if (this.hasLarge) {
            return false;
        }
        if (!this.connection.flowControl(this.onflowControlReady)) {
            return false;
        }
        Object object = this.creditsLock;
        synchronized (object) {
            return this.credits > 0 && this.sender.getLocalState() != EndpointState.CLOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupCredit() {
        Object object = this.creditsLock;
        synchronized (object) {
            this.credits = this.sender.getCredit() - this.pending.get();
            if (this.credits < 0) {
                this.credits = 0;
            }
        }
    }

    public Sender getSender() {
        return this.sender;
    }

    public void start() throws ActiveMQAMQPException {
        this.sessionSPI.start();
        try {
            if (this.brokerConsumer != null) {
                this.sessionSPI.startSender(this.brokerConsumer);
            }
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorStartingConsumer(e.getMessage());
        }
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        if (this.controller == null) {
            this.controller = new DefaultController(this.sessionSPI);
        }
        try {
            this.brokerConsumer = this.controller.init(this);
            this.onflowControlReady = () -> ((Consumer)this.brokerConsumer).promptDelivery();
        }
        catch (ActiveMQAMQPResourceLimitExceededException e1) {
            throw e1;
        }
        catch (ActiveMQSecurityException e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(e.getMessage());
        }
        catch (ActiveMQQueueMaxConsumerLimitReached e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingConsumer(e.getMessage());
        }
        catch (ActiveMQException e) {
            throw e;
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingConsumer(e.getMessage());
        }
    }

    protected String getClientId() {
        return this.connection.getRemoteContainer();
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
        this.closed = true;
        if (condition != null) {
            this.sender.setCondition(condition);
        }
        this.protonSession.removeSender(this.sender);
        this.connection.runLater(() -> {
            this.sender.close();
            try {
                this.sessionSPI.closeSender(this.brokerConsumer);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            this.sender.close();
            this.connection.flush();
        });
    }

    @Override
    public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
        this.closed = true;
        this.connection.runLater(() -> {
            try {
                this.internalClose(remoteLinkClose);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        });
    }

    private void internalClose(boolean remoteLinkClose) throws ActiveMQAMQPException {
        try {
            this.protonSession.removeSender(this.sender);
            this.sessionSPI.closeSender(this.brokerConsumer);
            if (remoteLinkClose) {
                this.controller.close();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new ActiveMQAMQPInternalErrorException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        if (this.closed) {
            return;
        }
        OperationContext oldContext = this.sessionSPI.recoverContext();
        try {
            Message message = ((MessageReference)delivery.getContext()).getMessage();
            DeliveryState remoteState = delivery.getRemoteState();
            if (remoteState != null && remoteState.getType() == DeliveryState.DeliveryStateType.Accepted) {
                if (!delivery.isSettled()) {
                    this.doAck(message);
                    delivery.settle();
                }
            } else {
                this.handleExtendedDeliveryOutcomes(message, delivery, remoteState);
            }
            if (!this.preSettle) {
                this.protonSession.replaceTag(delivery.getTag());
            }
        }
        finally {
            this.sessionSPI.afterIO(this.connectionFlusher);
            this.sessionSPI.resetContext(oldContext);
        }
    }

    protected void doAck(Message message) throws ActiveMQAMQPIllegalStateException {
        try {
            this.sessionSPI.ack(null, this.brokerConsumer, message);
        }
        catch (Exception e) {
            log.warn((Object)e.toString(), (Throwable)e);
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorAcknowledgingMessage(message.toString(), e.getMessage());
        }
    }

    private boolean handleExtendedDeliveryOutcomes(Message message, Delivery delivery, DeliveryState remoteState) throws ActiveMQAMQPException {
        boolean settleImmediate = true;
        boolean handled = true;
        if (remoteState == null) {
            log.debug((Object)("Received null disposition for delivery update: " + remoteState));
            return true;
        }
        switch (remoteState.getType()) {
            case Transactional: {
                TransactionalState txState = (TransactionalState)remoteState;
                ProtonTransactionImpl tx = (ProtonTransactionImpl)this.sessionSPI.getTransaction(txState.getTxnId(), false);
                if (txState.getOutcome() == null) break;
                settleImmediate = false;
                Outcome outcome = txState.getOutcome();
                if (!(outcome instanceof Accepted)) break;
                if (!delivery.remotelySettled()) {
                    TransactionalState txAccepted = new TransactionalState();
                    txAccepted.setOutcome((Outcome)Accepted.getInstance());
                    txAccepted.setTxnId(txState.getTxnId());
                    delivery.disposition((DeliveryState)txAccepted);
                }
                try {
                    this.sessionSPI.ack((Transaction)tx, this.brokerConsumer, message);
                    tx.addDelivery(delivery, this);
                    break;
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorAcknowledgingMessage(message.toString(), e.getMessage());
                }
            }
            case Released: {
                try {
                    this.sessionSPI.cancel(this.brokerConsumer, message, false);
                    break;
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                }
            }
            case Rejected: {
                try {
                    if (this.amqpTreatRejectAsUnmodifiedDeliveryFailed) {
                        this.sessionSPI.cancel(this.brokerConsumer, message, true);
                        break;
                    }
                    this.sessionSPI.reject(this.brokerConsumer, message);
                    break;
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                }
            }
            case Modified: {
                try {
                    Modified modification = (Modified)remoteState;
                    if (Boolean.TRUE.equals(modification.getUndeliverableHere())) {
                        message.rejectConsumer(this.brokerConsumer.sequentialID());
                    }
                    if (Boolean.TRUE.equals(modification.getDeliveryFailed())) {
                        this.sessionSPI.cancel(this.brokerConsumer, message, true);
                        break;
                    }
                    this.sessionSPI.cancel(this.brokerConsumer, message, false);
                    break;
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                }
            }
            default: {
                log.debug((Object)("Received null or unknown disposition for delivery update: " + remoteState));
                handled = false;
            }
        }
        if (settleImmediate) {
            delivery.settle();
        }
        return handled;
    }

    public void settle(Delivery delivery) {
        this.connection.requireInHandler();
        delivery.settle();
    }

    public synchronized void checkState() {
        this.sessionSPI.resumeDelivery(this.brokerConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deliverMessage(MessageReference messageReference, ServerConsumer consumer) throws Exception {
        if (this.closed) {
            return 0;
        }
        if (this.beforeDelivery != null) {
            this.beforeDelivery.accept((MessageReference)messageReference);
        }
        Object object = this.creditsLock;
        synchronized (object) {
            if (this.sender.getLocalState() == EndpointState.CLOSED) {
                return 0;
            }
            this.pending.incrementAndGet();
            --this.credits;
        }
        if (messageReference.getMessage() instanceof AMQPLargeMessage) {
            this.hasLarge = true;
        }
        if (messageReference instanceof Runnable && consumer.allowReferenceCallback()) {
            messageReference.onDelivery(this.executeDelivery);
            this.connection.runNow((Runnable)messageReference);
        } else {
            this.connection.runNow(() -> this.executeDelivery(messageReference));
        }
        return 1;
    }

    private void executeDelivery(MessageReference messageReference) {
        try {
            if (this.sender.getLocalState() == EndpointState.CLOSED) {
                log.debug((Object)("Not delivering message " + messageReference + " as the sender is closed and credits were available, if you see too many of these it means clients are issuing credits and closing the connection with pending credits a lot of times"));
                return;
            }
            AMQPMessage message = CoreAmqpConverter.checkAMQP(messageReference.getMessage(), this.sessionSPI.getStorageManager());
            if (this.sessionSPI.invokeOutgoing(message, (ActiveMQProtonRemotingConnection)this.sessionSPI.getTransportConnection().getProtocolConnection()) != null) {
                return;
            }
            if (message instanceof AMQPLargeMessage) {
                this.deliverLarge(messageReference, (AMQPLargeMessage)message);
            } else {
                this.deliverStandard(messageReference, message);
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            this.brokerConsumer.errorProcessing((Throwable)e, messageReference);
        }
    }

    private void finishLargeMessage() {
        this.lmUsageDown();
        this.pendingLargeMessage = null;
        this.hasLarge = false;
        this.brokerConsumer.promptDelivery();
    }

    private void lmUsageDown() {
        AMQPLargeMessage lm = null;
        if (this.pendingLargeMessage != null) {
            lm = this.pendingLargeMessage.message;
        }
        if (lm != null) {
            lm.usageDown();
        }
    }

    private void deliverLarge(MessageReference messageReference, AMQPLargeMessage message) {
        byte[] tag = this.preSettle ? new byte[]{} : this.protonSession.getTag();
        Delivery delivery = this.sender.delivery(tag, 0, tag.length);
        delivery.setMessageFormat((int)message.getMessageFormat());
        delivery.setContext((Object)messageReference);
        message.usageUp();
        this.pendingLargeMessage = new LargeMessageDeliveryContext(messageReference, message, delivery);
        this.pendingLargeMessage.deliver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverStandard(MessageReference messageReference, AMQPMessage message) {
        ReadableBuffer sendBuffer = message.getSendBuffer(messageReference.getDeliveryCount(), messageReference);
        byte[] tag = this.preSettle ? new byte[]{} : this.protonSession.getTag();
        boolean releaseRequired = sendBuffer instanceof NettyReadable;
        Delivery delivery = this.sender.delivery(tag, 0, tag.length);
        delivery.setMessageFormat((int)message.getMessageFormat());
        delivery.setContext((Object)messageReference);
        try {
            if (releaseRequired) {
                this.sender.send(sendBuffer);
                releaseRequired = false;
                ((NettyReadable)sendBuffer).getByteBuf().release();
            } else {
                this.sender.sendNoCopy(sendBuffer);
            }
            if (this.preSettle) {
                try {
                    this.sessionSPI.ack(null, this.brokerConsumer, messageReference.getMessage());
                }
                catch (Exception e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                delivery.settle();
            } else {
                this.sender.advance();
            }
            this.connection.flush();
        }
        finally {
            Object object = this.creditsLock;
            synchronized (object) {
                this.pending.decrementAndGet();
            }
            if (releaseRequired) {
                ((NettyReadable)sendBuffer).getByteBuf().release();
            }
        }
    }

    private static boolean hasCapabilities(Symbol symbol, Source source) {
        if (source != null && source.getCapabilities() != null) {
            for (Symbol cap : source.getCapabilities()) {
                if (!symbol.equals(cap)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasRemoteDesiredCapability(Link link, Symbol capability) {
        Symbol[] remoteDesiredCapabilities = link.getRemoteDesiredCapabilities();
        if (remoteDesiredCapabilities != null) {
            for (Symbol cap : remoteDesiredCapabilities) {
                if (!capability.equals(cap)) continue;
                return true;
            }
        }
        return false;
    }

    private static SimpleString createQueueName(boolean useCoreSubscriptionNaming, String clientId, String pubId, boolean shared, boolean global, boolean isVolatile) {
        Object queue;
        if (useCoreSubscriptionNaming) {
            boolean durable = !isVolatile;
            String subscriptionName = pubId.contains("|") ? pubId.split("\\|")[0] : pubId;
            String clientID = clientId == null || clientId.isEmpty() || global ? null : clientId;
            return DestinationUtil.createQueueNameForSubscription((boolean)durable, (String)clientID, (String)subscriptionName);
        }
        Object object = queue = clientId == null || clientId.isEmpty() || global ? pubId : clientId + "." + pubId;
        if (shared) {
            if (((String)queue).contains("|")) {
                queue = ((String)queue).split("\\|")[0];
            }
            if (isVolatile) {
                queue = (String)queue + ":shared-volatile";
            }
            if (global) {
                queue = (String)queue + ":global";
            }
        }
        return SimpleString.toSimpleString((String)queue);
    }

    public void reportDrained() {
        this.connection.requireInHandler();
        this.sender.drained();
        this.connection.instantFlush();
    }

    public AMQPSessionContext getSessionContext() {
        return this.protonSession;
    }

    class DefaultController
    implements SenderController {
        private boolean shared = false;
        boolean global = false;
        boolean multicast;
        final AMQPSessionCallback sessionSPI;
        SimpleString queue = null;
        SimpleString tempQueueName;
        String selector;
        private final RoutingType defaultRoutingType = RoutingType.ANYCAST;
        private RoutingType routingTypeToUse = RoutingType.ANYCAST;
        private boolean isVolatile = false;

        DefaultController(AMQPSessionCallback sessionSPI) {
            this.sessionSPI = sessionSPI;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Consumer init(ProtonServerSenderContext senderContext) throws Exception {
            Map.Entry<Symbol, DescribedType> filter;
            Source source = (Source)ProtonServerSenderContext.this.sender.getRemoteSource();
            HashMap<Symbol, DescribedType> supportedFilters = new HashMap<Symbol, DescribedType>();
            ProtonServerSenderContext.this.sender.setSenderSettleMode(ProtonServerSenderContext.this.sender.getRemoteSenderSettleMode());
            ProtonServerSenderContext.this.sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            if (source != null && (filter = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.JMS_SELECTOR_FILTER_IDS)) != null) {
                this.selector = filter.getValue().getDescribed().toString();
                try {
                    SelectorParser.parse((String)this.selector);
                }
                catch (FilterException e) {
                    throw new ActiveMQAMQPException(AmqpError.INVALID_FIELD, "Invalid filter", ActiveMQExceptionType.INVALID_FILTER_EXPRESSION);
                }
                supportedFilters.put(filter.getKey(), filter.getValue());
            }
            if (source == null) {
                String clientId = ProtonServerSenderContext.this.getClientId();
                String pubId = ProtonServerSenderContext.this.sender.getName();
                this.global = ProtonServerSenderContext.hasRemoteDesiredCapability((Link)ProtonServerSenderContext.this.sender, GLOBAL);
                this.shared = ProtonServerSenderContext.hasRemoteDesiredCapability((Link)ProtonServerSenderContext.this.sender, SHARED);
                this.queue = ProtonServerSenderContext.createQueueName(ProtonServerSenderContext.this.connection.isUseCoreSubscriptionNaming(), clientId, pubId, true, this.global, false);
                QueueQueryResult result = this.sessionSPI.queueQuery(this.queue, RoutingType.MULTICAST, false);
                this.multicast = true;
                this.routingTypeToUse = RoutingType.MULTICAST;
                if (!result.isExists()) throw new ActiveMQAMQPNotFoundException("Unknown subscription link: " + ProtonServerSenderContext.this.sender.getName());
                source = new Source();
                source.setAddress(this.queue.toString());
                source.setDurable(TerminusDurability.UNSETTLED_STATE);
                source.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
                source.setDistributionMode(COPY);
                source.setCapabilities(new Symbol[]{TOPIC});
                SimpleString filterString = result.getFilterString();
                if (filterString != null) {
                    this.selector = filterString.toString();
                    boolean noLocal = false;
                    String remoteContainerId = ProtonServerSenderContext.this.sender.getSession().getConnection().getRemoteContainer();
                    String noLocalFilter = MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + remoteContainerId + "'";
                    if (this.selector.endsWith(noLocalFilter)) {
                        if (this.selector.length() > noLocalFilter.length()) {
                            noLocalFilter = " AND " + noLocalFilter;
                            this.selector = this.selector.substring(0, this.selector.length() - noLocalFilter.length());
                        } else {
                            this.selector = null;
                        }
                        noLocal = true;
                    }
                    if (noLocal) {
                        supportedFilters.put(AmqpSupport.NO_LOCAL_NAME, AmqpNoLocalFilter.NO_LOCAL);
                    }
                    if (this.selector != null && !this.selector.trim().isEmpty()) {
                        supportedFilters.put(AmqpSupport.JMS_SELECTOR_NAME, new AmqpJmsSelectorFilter(this.selector));
                    }
                }
                ProtonServerSenderContext.this.sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            } else if (source.getDynamic()) {
                this.tempQueueName = this.queue = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
                try {
                    this.sessionSPI.createTemporaryQueue(this.queue, RoutingType.ANYCAST);
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
                }
                source.setAddress(this.queue.toString());
            } else {
                SimpleString matchingAnycastQueue;
                Set routingTypes;
                AddressQueryResult addressQueryResult;
                boolean clientDefined;
                SimpleString addressToUse;
                SimpleString queueNameToUse = null;
                this.shared = ProtonServerSenderContext.hasCapabilities(SHARED, source);
                this.global = ProtonServerSenderContext.hasCapabilities(GLOBAL, source);
                if (CompositeAddress.isFullyQualified((String)source.getAddress())) {
                    addressToUse = SimpleString.toSimpleString((String)CompositeAddress.extractAddressName((String)source.getAddress()));
                    queueNameToUse = SimpleString.toSimpleString((String)CompositeAddress.extractQueueName((String)source.getAddress()));
                } else {
                    addressToUse = SimpleString.toSimpleString((String)source.getAddress());
                }
                boolean bl = clientDefined = ProtonServerSenderContext.hasCapabilities(TOPIC, source) || ProtonServerSenderContext.hasCapabilities(QUEUE, source);
                if (clientDefined) {
                    this.multicast = ProtonServerSenderContext.hasCapabilities(TOPIC, source);
                    addressQueryResult = null;
                    try {
                        addressQueryResult = this.sessionSPI.addressQuery(addressToUse, this.multicast ? RoutingType.MULTICAST : RoutingType.ANYCAST, true);
                    }
                    catch (ActiveMQSecurityException e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(e.getMessage());
                    }
                    catch (ActiveMQAMQPException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                    }
                    if (!addressQueryResult.isExists()) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                    }
                    routingTypes = addressQueryResult.getRoutingTypes();
                    if (this.multicast && !routingTypes.contains(RoutingType.MULTICAST)) {
                        throw new ActiveMQAMQPIllegalStateException("Address " + addressToUse + " is not configured for topic support");
                    }
                    if (!this.multicast && !routingTypes.contains(RoutingType.ANYCAST) && queueNameToUse == null) {
                        throw new ActiveMQAMQPIllegalStateException("Address " + addressToUse + " is not configured for queue support");
                    }
                } else {
                    addressQueryResult = null;
                    try {
                        addressQueryResult = this.sessionSPI.addressQuery(addressToUse, this.defaultRoutingType, true);
                    }
                    catch (ActiveMQSecurityException e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(e.getMessage());
                    }
                    catch (ActiveMQAMQPException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                    }
                    if (!addressQueryResult.isExists()) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                    }
                    routingTypes = addressQueryResult.getRoutingTypes();
                    this.multicast = routingTypes.contains(RoutingType.MULTICAST) && routingTypes.size() == 1;
                }
                RoutingType routingType = this.routingTypeToUse = this.multicast ? RoutingType.MULTICAST : RoutingType.ANYCAST;
                if (this.multicast) {
                    Map.Entry<Symbol, DescribedType> filter2 = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.NO_LOCAL_FILTER_IDS);
                    if (filter2 != null) {
                        String remoteContainerId = ProtonServerSenderContext.this.sender.getSession().getConnection().getRemoteContainer();
                        String noLocalFilter = MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + remoteContainerId + "'";
                        this.selector = this.selector != null ? this.selector + " AND " + noLocalFilter : noLocalFilter;
                        supportedFilters.put(filter2.getKey(), filter2.getValue());
                    }
                    this.queue = this.getMatchingQueue(queueNameToUse, addressToUse, RoutingType.MULTICAST);
                    SimpleString simpleStringSelector = SimpleString.toSimpleString((String)this.selector);
                    if (this.queue != null) {
                        this.multicast = false;
                    } else if (TerminusDurability.UNSETTLED_STATE.equals((Object)source.getDurable()) || TerminusDurability.CONFIGURATION.equals((Object)source.getDurable())) {
                        String clientId = ProtonServerSenderContext.this.getClientId();
                        String pubId = ProtonServerSenderContext.this.sender.getName();
                        this.queue = ProtonServerSenderContext.createQueueName(ProtonServerSenderContext.this.connection.isUseCoreSubscriptionNaming(), clientId, pubId, this.shared, this.global, false);
                        QueueQueryResult result = this.sessionSPI.queueQuery(this.queue, this.routingTypeToUse, false);
                        if (result.isExists()) {
                            if (!(result.isConfigurationManaged().booleanValue() || Objects.equals(result.getAddress(), addressToUse) && Objects.equals(result.getFilterString(), simpleStringSelector))) {
                                if (result.getConsumerCount() != 0) throw new ActiveMQAMQPIllegalStateException("Unable to recreate subscription, consumers already exist");
                                this.sessionSPI.deleteQueue(this.queue);
                                if (this.shared) {
                                    this.sessionSPI.createSharedDurableQueue(addressToUse, RoutingType.MULTICAST, this.queue, simpleStringSelector);
                                } else {
                                    this.sessionSPI.createUnsharedDurableQueue(addressToUse, RoutingType.MULTICAST, this.queue, simpleStringSelector);
                                }
                            }
                        } else if (this.shared) {
                            this.sessionSPI.createSharedDurableQueue(addressToUse, RoutingType.MULTICAST, this.queue, simpleStringSelector);
                        } else {
                            this.sessionSPI.createUnsharedDurableQueue(addressToUse, RoutingType.MULTICAST, this.queue, simpleStringSelector);
                        }
                    } else {
                        this.isVolatile = true;
                        if (this.shared && ProtonServerSenderContext.this.sender.getName() != null) {
                            this.queue = ProtonServerSenderContext.createQueueName(ProtonServerSenderContext.this.connection.isUseCoreSubscriptionNaming(), ProtonServerSenderContext.this.getClientId(), ProtonServerSenderContext.this.sender.getName(), this.shared, this.global, this.isVolatile);
                            QueueQueryResult result = this.sessionSPI.queueQuery(this.queue, this.routingTypeToUse, false);
                            if (!(result.isExists() && Objects.equals(result.getAddress(), addressToUse) && Objects.equals(result.getFilterString(), simpleStringSelector) || result.isConfigurationManaged().booleanValue())) {
                                this.sessionSPI.createSharedVolatileQueue(addressToUse, RoutingType.MULTICAST, this.queue, simpleStringSelector);
                            }
                        } else {
                            this.tempQueueName = this.queue = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
                            try {
                                this.sessionSPI.createTemporaryQueue(addressToUse, this.queue, RoutingType.MULTICAST, simpleStringSelector);
                            }
                            catch (Exception e) {
                                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
                            }
                        }
                    }
                } else if (queueNameToUse != null) {
                    this.routingTypeToUse = null;
                    matchingAnycastQueue = this.getMatchingQueue(queueNameToUse, addressToUse, null);
                    if (matchingAnycastQueue == null) throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                    this.queue = matchingAnycastQueue;
                } else {
                    matchingAnycastQueue = this.sessionSPI.getMatchingQueue(addressToUse, RoutingType.ANYCAST);
                    this.queue = matchingAnycastQueue != null ? matchingAnycastQueue : addressToUse;
                }
                if (this.queue == null) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressNotSet();
                }
                try {
                    if (!this.sessionSPI.queueQuery(this.queue, this.routingTypeToUse, !this.multicast).isExists()) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                    }
                }
                catch (ActiveMQAMQPNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
            }
            ProtonServerSenderContext.this.preSettle = ProtonServerSenderContext.this.sender.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED;
            source.setFilter(supportedFilters.isEmpty() ? null : supportedFilters);
            boolean browseOnly = !this.multicast && source.getDistributionMode() != null && source.getDistributionMode().equals(COPY);
            return (Consumer)this.sessionSPI.createSender(senderContext, this.queue, this.multicast ? null : this.selector, browseOnly);
        }

        private SimpleString getMatchingQueue(SimpleString queueName, SimpleString address, RoutingType routingType) throws Exception {
            if (queueName != null) {
                QueueQueryResult result = this.sessionSPI.queueQuery(CompositeAddress.toFullyQualified((SimpleString)address, (SimpleString)queueName), routingType, true);
                if (!result.isExists()) {
                    throw new ActiveMQAMQPNotFoundException("Queue: '" + queueName + "' does not exist");
                }
                if (!result.getAddress().equals((Object)address)) {
                    throw new ActiveMQAMQPNotFoundException("Queue: '" + queueName + "' does not exist for address '" + address + "'");
                }
                return this.sessionSPI.getMatchingQueue(address, queueName, routingType);
            }
            return null;
        }

        @Override
        public void close() throws Exception {
            Source source = (Source)ProtonServerSenderContext.this.sender.getSource();
            if (source != null && source.getAddress() != null && this.multicast) {
                SimpleString queueName = SimpleString.toSimpleString((String)source.getAddress());
                QueueQueryResult result = this.sessionSPI.queueQuery(queueName, this.routingTypeToUse, false);
                if (result.isExists() && source.getDynamic()) {
                    this.sessionSPI.deleteQueue(queueName);
                } else if (source.getDurable() == TerminusDurability.NONE && this.tempQueueName != null && (source.getExpiryPolicy() == TerminusExpiryPolicy.LINK_DETACH || source.getExpiryPolicy() == TerminusExpiryPolicy.SESSION_END)) {
                    this.sessionSPI.removeTemporaryQueue(this.tempQueueName);
                } else {
                    SimpleString queue;
                    String clientId = ProtonServerSenderContext.this.getClientId();
                    String pubId = ProtonServerSenderContext.this.sender.getName();
                    if (pubId.contains("|")) {
                        pubId = pubId.split("\\|")[0];
                    }
                    if ((result = this.sessionSPI.queueQuery(queue = ProtonServerSenderContext.createQueueName(ProtonServerSenderContext.this.connection.isUseCoreSubscriptionNaming(), clientId, pubId, this.shared, this.global, this.isVolatile), this.multicast ? RoutingType.MULTICAST : RoutingType.ANYCAST, false)).isExists() && !this.isVolatile && result.getConsumerCount() == 0) {
                        this.sessionSPI.deleteQueue(queue);
                    }
                }
            } else if (source != null && source.getDynamic() && (source.getExpiryPolicy() == TerminusExpiryPolicy.LINK_DETACH || source.getExpiryPolicy() == TerminusExpiryPolicy.SESSION_END)) {
                try {
                    this.sessionSPI.removeTemporaryQueue(SimpleString.toSimpleString((String)source.getAddress()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class LargeMessageDeliveryContext {
        long position = 0L;
        final MessageReference reference;
        final AMQPLargeMessage message;
        final Delivery delivery;
        boolean initialPacketHandled;

        LargeMessageDeliveryContext(MessageReference reference, AMQPLargeMessage message, Delivery delivery) {
            this.reference = reference;
            this.message = message;
            this.delivery = delivery;
        }

        void resume() {
            ProtonServerSenderContext.this.connection.runNow(this::deliver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void deliver() {
            int frameSize = ProtonServerSenderContext.this.protonSession.session.getConnection().getTransport().getOutboundFrameSizeLimit() - 50 - (this.delivery.getTag() != null ? this.delivery.getTag().length : 0);
            try {
                ByteBuf frameBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(frameSize, frameSize);
                NettyReadable frameView = new NettyReadable(frameBuffer);
                try (LargeBodyReader context = this.message.getLargeBodyReader();){
                    context.open();
                    context.position(this.position);
                    long bodySize = context.getSize();
                    frameBuffer.ensureWritable(frameSize);
                    if (!this.initialPacketHandled && ProtonServerSenderContext.this.sender.getLocalState() != EndpointState.CLOSED) {
                        if (!this.deliverInitialPacket(context, frameBuffer)) {
                            return;
                        }
                        this.initialPacketHandled = true;
                    }
                    while (ProtonServerSenderContext.this.sender.getLocalState() != EndpointState.CLOSED && this.position < bodySize) {
                        if (!ProtonServerSenderContext.this.connection.flowControl(this::resume)) {
                            return;
                        }
                        frameBuffer.clear();
                        int readSize = context.readInto(frameBuffer.internalNioBuffer(0, frameSize));
                        frameBuffer.writerIndex(readSize);
                        ProtonServerSenderContext.this.sender.send((ReadableBuffer)frameView);
                        this.position += (long)readSize;
                        if (readSize <= 0 || this.position >= bodySize) continue;
                        ProtonServerSenderContext.this.connection.instantFlush();
                    }
                }
                finally {
                    frameBuffer.release();
                }
                if (ProtonServerSenderContext.this.preSettle) {
                    try {
                        ProtonServerSenderContext.this.sessionSPI.ack(null, ProtonServerSenderContext.this.brokerConsumer, this.reference.getMessage());
                    }
                    catch (Exception e) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    this.delivery.settle();
                } else {
                    ProtonServerSenderContext.this.sender.advance();
                }
                ProtonServerSenderContext.this.connection.instantFlush();
                Object object = ProtonServerSenderContext.this.creditsLock;
                synchronized (object) {
                    ProtonServerSenderContext.this.pending.decrementAndGet();
                }
                ProtonServerSenderContext.this.finishLargeMessage();
                return;
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                ProtonServerSenderContext.this.brokerConsumer.errorProcessing((Throwable)e, this.reference);
            }
        }

        private boolean deliverInitialPacket(LargeBodyReader context, ByteBuf frameBuffer) throws Exception {
            int writtenBytes;
            assert (this.position == 0L && context.position() == 0L && !this.initialPacketHandled);
            if (!ProtonServerSenderContext.this.connection.flowControl(this::resume)) {
                return false;
            }
            frameBuffer.clear();
            this.message.checkReference(this.reference);
            DeliveryAnnotations deliveryAnnotationsToEncode = this.reference.getProtocolData() != null && this.reference.getProtocolData() instanceof DeliveryAnnotations ? (DeliveryAnnotations)this.reference.getProtocolData() : null;
            try {
                this.replaceInitialHeader(deliveryAnnotationsToEncode, context, new NettyWritable(frameBuffer));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                assert (this.position == 0L) : "this shouldn't happen unless replaceInitialHeader is updating position before modifying frameBuffer";
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Delivery of message failed with an overFlowException, retrying again with expandable buffer");
                }
                this.sendAndFlushInitialPacket(deliveryAnnotationsToEncode, context);
                return true;
            }
            int readSize = 0;
            int writableBytes = frameBuffer.writableBytes();
            if (writableBytes != 0 && (readSize = context.readInto(frameBuffer.internalNioBuffer(writtenBytes = frameBuffer.writerIndex(), writableBytes))) > 0) {
                frameBuffer.writerIndex(writtenBytes + readSize);
            }
            ProtonServerSenderContext.this.sender.send((ReadableBuffer)new NettyReadable(frameBuffer));
            if (readSize > 0) {
                this.position += (long)readSize;
            }
            ProtonServerSenderContext.this.connection.instantFlush();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendAndFlushInitialPacket(DeliveryAnnotations deliveryAnnotationsToEncode, LargeBodyReader context) throws Exception {
            ByteBuf nettyBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(AMQPMessageBrokerAccessor.getRemainingBodyPosition(this.message) * 2);
            try {
                this.replaceInitialHeader(deliveryAnnotationsToEncode, context, new NettyWritable(nettyBuffer));
                ProtonServerSenderContext.this.sender.send((ReadableBuffer)new NettyReadable(nettyBuffer));
            }
            finally {
                nettyBuffer.release();
                ProtonServerSenderContext.this.connection.instantFlush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int replaceInitialHeader(DeliveryAnnotations deliveryAnnotationsToEncode, LargeBodyReader context, WritableBuffer buf) throws Exception {
            TLSEncode.getEncoder().setByteBuffer(buf);
            try {
                int proposedPosition = this.writeHeaderAndAnnotations(deliveryAnnotationsToEncode);
                if (this.message.isReencoded()) {
                    proposedPosition = this.writeMessageAnnotationsPropertiesAndApplicationProperties(context, this.message);
                }
                context.position((long)proposedPosition);
                this.position = proposedPosition;
                int n = (int)this.position;
                return n;
            }
            finally {
                TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            }
        }

        private int writeMessageAnnotationsPropertiesAndApplicationProperties(LargeBodyReader context, AMQPLargeMessage message) throws Exception {
            int bodyPosition = AMQPMessageBrokerAccessor.getRemainingBodyPosition(message);
            assert (bodyPosition > 0);
            this.writeMessageAnnotationsPropertiesAndApplicationPropertiesInternal(message);
            return bodyPosition;
        }

        private void writeMessageAnnotationsPropertiesAndApplicationPropertiesInternal(AMQPLargeMessage message) {
            ApplicationProperties applicationProperties;
            Properties amqpProperties;
            MessageAnnotations messageAnnotations = AMQPMessageBrokerAccessor.getDecodedMessageAnnotations(message);
            if (messageAnnotations != null) {
                TLSEncode.getEncoder().writeObject((Object)messageAnnotations);
            }
            if ((amqpProperties = AMQPMessageBrokerAccessor.getCurrentProperties(message)) != null) {
                TLSEncode.getEncoder().writeObject((Object)amqpProperties);
            }
            if ((applicationProperties = AMQPMessageBrokerAccessor.getDecodedApplicationProperties(message)) != null) {
                TLSEncode.getEncoder().writeObject((Object)applicationProperties);
            }
        }

        private int writeHeaderAndAnnotations(DeliveryAnnotations deliveryAnnotationsToEncode) {
            Header header = AMQPMessageBrokerAccessor.getCurrentHeader(this.message);
            if (header != null) {
                TLSEncode.getEncoder().writeObject((Object)header);
            }
            if (deliveryAnnotationsToEncode != null) {
                TLSEncode.getEncoder().writeObject((Object)deliveryAnnotationsToEncode);
            }
            return this.message.getPositionAfterDeliveryAnnotations();
        }
    }

    private final class ConnectionFlushIOCallback
    implements IOCallback {
        private ConnectionFlushIOCallback() {
        }

        public void done() {
            ProtonServerSenderContext.this.connection.flush();
        }

        public void onError(int errorCode, String errorMessage) {
            ProtonServerSenderContext.this.connection.flush();
        }
    }
}

