/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.DefaultJWTCallerPrincipalFactory;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import io.smallrye.jwt.auth.principal.ParseException;
import io.smallrye.jwt.auth.principal.PrincipalLogging;
import java.net.URL;
import java.security.AccessController;
import java.util.ServiceLoader;

public abstract class JWTCallerPrincipalFactory {
    private static volatile JWTCallerPrincipalFactory instance;

    public static JWTCallerPrincipalFactory instance() {
        JWTCallerPrincipalFactory newInstance;
        if (instance != null) {
            return instance;
        }
        ClassLoader cl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        if (cl == null) {
            cl = JWTCallerPrincipalFactory.class.getClassLoader();
        }
        if ((newInstance = JWTCallerPrincipalFactory.loadSpi(cl)) == null && cl != JWTCallerPrincipalFactory.class.getClassLoader()) {
            cl = JWTCallerPrincipalFactory.class.getClassLoader();
            newInstance = JWTCallerPrincipalFactory.loadSpi(cl);
        }
        if (newInstance == null) {
            newInstance = new DefaultJWTCallerPrincipalFactory();
        }
        return newInstance;
    }

    private static JWTCallerPrincipalFactory loadSpi(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        JWTCallerPrincipalFactory instance = JWTCallerPrincipalFactory.loadSpi(cl.getParent());
        if (instance == null) {
            ServiceLoader<JWTCallerPrincipalFactory> sl = ServiceLoader.load(JWTCallerPrincipalFactory.class, cl);
            URL u = cl.getResource("/META-INF/services/io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory");
            PrincipalLogging.log.loadSpi(cl, u, sl);
            try {
                for (JWTCallerPrincipalFactory spi : sl) {
                    if (instance != null) {
                        PrincipalLogging.log.multipleJWTCallerPrincipalFactoryFound(spi.getClass().getName(), instance.getClass().getName());
                        break;
                    }
                    PrincipalLogging.log.currentSpi(sl, spi);
                    instance = spi;
                }
            }
            catch (Exception e) {
                PrincipalLogging.log.failedToLocateJWTCallerPrincipalFactoryProvider(e);
            }
        }
        return instance;
    }

    public static synchronized void setInstance(JWTCallerPrincipalFactory resolver) {
        instance = resolver;
    }

    public abstract JWTCallerPrincipal parse(String var1, JWTAuthContextInfo var2) throws ParseException;
}

