/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.cdi.clientwindow;

import com.sun.faces.cdi.clientwindow.ClientWindowScopeManager;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindowScoped;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;

@Typed
public class ClientWindowScopeContext
implements Context,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(ClientWindowScopeContext.class.getName());
    private static final long serialVersionUID = -6559364724281899428L;

    public ClientWindowScopeContext() {
        LOGGER.log(Level.FINEST, "Creating ClientWindowScope CDI context");
    }

    private void assertNotReleased() {
        if (!this.isActive()) {
            LOGGER.log(Level.SEVERE, "Trying to access ClientWindowScope CDI context while it is not active");
            throw new ContextNotActiveException();
        }
    }

    public <T> T get(Contextual<T> contextual) {
        ClientWindowScopeManager manager;
        this.assertNotReleased();
        T result = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (manager = ClientWindowScopeManager.getInstance(facesContext)) != null) {
            result = manager.getContextManager().getBean(facesContext, contextual);
        }
        return result;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creational) {
        ClientWindowScopeManager manager;
        FacesContext facesContext;
        this.assertNotReleased();
        T result = this.get(contextual);
        if (result == null && (facesContext = FacesContext.getCurrentInstance()) != null && (result = (manager = ClientWindowScopeManager.getInstance(facesContext)).getContextManager().getBean(facesContext, contextual)) == null) {
            result = manager.getContextManager().createBean(facesContext, contextual, creational);
        }
        return result;
    }

    public Class<? extends Annotation> getScope() {
        return ClientWindowScoped.class;
    }

    public boolean isActive() {
        boolean result = false;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            result = facesContext.getExternalContext().getClientWindow() != null;
        }
        return result;
    }
}

