/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health;

import java.security.SecureRandom;
import java.util.function.BooleanSupplier;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class HealthStatus {
    private static final SecureRandom random = new SecureRandom();

    public static HealthCheck up(String name) {
        return HealthStatus.status(name, true);
    }

    public static HealthCheck down(String name) {
        return HealthStatus.status(name, false);
    }

    public static HealthCheck status(BooleanSupplier supplier) {
        return HealthStatus.status(supplier.getAsBoolean());
    }

    public static HealthCheck status(boolean status) {
        return HealthStatus.status(HealthStatus.generateRandomHealthCheckName(), status);
    }

    public static HealthCheck status(String name, BooleanSupplier supplier) {
        return HealthStatus.status(name, supplier.getAsBoolean());
    }

    public static HealthCheck status(String name, boolean status) {
        return () -> HealthCheckResponse.named((String)name).status(status).build();
    }

    private static final String generateRandomHealthCheckName() {
        int suffix = random.nextInt(99999);
        return String.format("unnamed-health-check-%05d", suffix);
    }
}

