/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jboss.as.ee.logging.EeLogger;

public class ContextServiceTypesConfiguration
implements Serializable {
    public static final ContextServiceTypesConfiguration DEFAULT = new ContextServiceTypesConfiguration(null, null, null);
    private static final long serialVersionUID = -8818025042707301480L;
    private final Set<String> cleared;
    private final Set<String> propagated;
    private final Set<String> unchanged;

    private ContextServiceTypesConfiguration(Set<String> cleared, Set<String> propagated, Set<String> unchanged) {
        this.cleared = cleared == null || cleared.isEmpty() ? Set.of("Transaction") : Collections.unmodifiableSet(cleared);
        this.propagated = propagated == null || propagated.isEmpty() ? Set.of("Remaining") : Collections.unmodifiableSet(propagated);
        this.unchanged = unchanged == null || unchanged.isEmpty() ? Set.of("") : Collections.unmodifiableSet(unchanged);
    }

    public boolean isCleared(String contextType) {
        return this.isTypeIncluded(contextType, this.cleared, this.propagated, this.unchanged);
    }

    public boolean isPropagated(String contextType) {
        return this.isTypeIncluded(contextType, this.propagated, this.cleared, this.unchanged);
    }

    public boolean isUnchanged(String contextType) {
        return this.isTypeIncluded(contextType, this.unchanged, this.cleared, this.propagated);
    }

    private boolean isTypeIncluded(String contextType, Set<String> contextTypes, Set<String> otherContextTypes1, Set<String> otherContextTypes2) {
        Objects.requireNonNull(contextType);
        if (contextTypes.contains(contextType)) {
            return true;
        }
        if (contextTypes.contains("Remaining")) {
            return !otherContextTypes1.contains(contextType) && !otherContextTypes2.contains(contextType);
        }
        return false;
    }

    public static class Builder {
        private Set<String> cleared;
        private Set<String> propagated;
        private Set<String> unchanged;

        public Builder setCleared(Set<String> cleared) {
            this.cleared = cleared;
            return this;
        }

        public Builder setCleared(String[] cleared) {
            if (cleared == null || cleared.length == 0) {
                this.cleared = null;
            } else {
                this.cleared = new HashSet<String>();
                Collections.addAll(this.cleared, cleared);
            }
            return this;
        }

        public Builder setPropagated(Set<String> propagated) {
            this.propagated = propagated;
            return this;
        }

        public Builder setPropagated(String[] propagated) {
            if (propagated == null || propagated.length == 0) {
                this.propagated = null;
            } else {
                this.propagated = new HashSet<String>();
                Collections.addAll(this.propagated, propagated);
            }
            return this;
        }

        public Builder setUnchanged(Set<String> unchanged) {
            this.unchanged = unchanged;
            return this;
        }

        public Builder setUnchanged(String[] unchanged) {
            if (unchanged == null || unchanged.length == 0) {
                this.unchanged = null;
            } else {
                this.unchanged = new HashSet<String>();
                Collections.addAll(this.unchanged, unchanged);
            }
            return this;
        }

        public ContextServiceTypesConfiguration build() throws IllegalStateException {
            int remainingCount = 0;
            if (this.cleared != null && this.cleared.contains("Remaining")) {
                ++remainingCount;
            }
            if (this.propagated == null || this.propagated.isEmpty() || this.propagated.contains("Remaining")) {
                ++remainingCount;
            }
            if (this.unchanged != null && this.unchanged.contains("Remaining")) {
                ++remainingCount;
            }
            if (remainingCount > 1) {
                throw EeLogger.ROOT_LOGGER.multipleUsesOfAllRemaining();
            }
            if (!(this.cleared != null && !this.cleared.isEmpty() || this.propagated != null && !this.propagated.isEmpty() || this.unchanged != null && !this.unchanged.isEmpty())) {
                return DEFAULT;
            }
            return new ContextServiceTypesConfiguration(this.cleared, this.propagated, this.unchanged);
        }
    }
}

