/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.matrix;

import java.io.IOException;
import org.aesh.command.shell.Shell;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;

public class MatrixPoint {
    private static final int randNum = 90;
    private static final int randMin = 33;
    private static final TerminalColor WHITE_COLOR = new TerminalColor(Color.WHITE, Color.DEFAULT);
    private static final TerminalColor GREEN_COLOR = new TerminalColor(Color.GREEN, Color.DEFAULT);
    private final int rows;
    private final int columns;
    private final byte[] out;
    private int cyclesToLive;
    private int position;
    private int length;
    private char character;
    private char defaultCharacter;
    private boolean previousWasText = false;

    public MatrixPoint(int rows, int columns, int y, int x) {
        this.rows = rows;
        this.columns = columns;
        String cursorPosition = "\u001b[" + y + ";" + x + "H";
        this.out = new byte[cursorPosition.getBytes().length + 2];
        int counter = 0;
        byte[] byArray = cursorPosition.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte b;
            this.out[counter] = b = byArray[i];
            ++counter;
        }
        this.character = (char)32;
        this.previousWasText = MatrixPoint.shouldStartWithText();
    }

    public void getChanges(Shell shell) throws IOException {
        if (this.out[this.out.length - 2] != -1 && this.defaultCharacter == '\u0000') {
            if (this.length == this.cyclesToLive && this.character != ' ') {
                shell.write(WHITE_COLOR.fullString());
                if (this.out[this.out.length - 1] != -1) {
                    shell.write(new String(this.out));
                } else {
                    shell.write(new String(this.out, 0, this.out.length - 1));
                }
                shell.write(GREEN_COLOR.fullString());
            } else {
                if (this.out[this.out.length - 1] != -1) {
                    shell.write(new String(this.out));
                } else {
                    shell.write(new String(this.out, 0, this.out.length - 1));
                }
                this.out[this.out.length - 2] = -1;
                this.out[this.out.length - 1] = -1;
            }
        }
    }

    public void newCycle() {
        if (this.previousWasText) {
            int l = this.getNewSpaceLength();
            this.previousWasText = false;
            this.newCycle(l, l, false);
        } else {
            int l = this.getNewTextLength();
            this.previousWasText = true;
            this.newCycle(l, l, true);
        }
    }

    public void newCycle(int position, int length, boolean text) {
        this.length = length;
        this.cyclesToLive = length;
        this.character = this.defaultCharacter != '\u0000' ? this.defaultCharacter : (text ? (char)MatrixPoint.getRandomChar() : (char)32);
        this.updateOut(this.character);
    }

    public void nextCycle() {
        if (this.cyclesToLive > 0) {
            --this.cyclesToLive;
        } else if (this.cyclesToLive == 0) {
            this.character = (char)32;
            this.length = 0;
            this.position = 0;
            this.updateOut(this.character);
        }
    }

    public boolean isPartOfTextOrSpace() {
        return this.length > 0;
    }

    public boolean isNextUp() {
        return this.length - this.cyclesToLive > 0 && this.character != ' ';
    }

    private void updateOut(char c) {
        this.out[this.out.length - 2] = (byte)(c >>> 8 & 0xFF);
        this.out[this.out.length - 1] = (byte)(c & 0xFF);
    }

    public int getPosition() {
        return this.position;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setDefaultCharacter(char c) {
        this.defaultCharacter = c;
    }

    private static int getRandomChar() {
        return (int)(Math.random() * 90.0) + 33;
    }

    private int getNewTextLength() {
        return (int)(Math.random() * (double)(this.rows - 3)) + 3;
    }

    private int getNewSpaceLength() {
        return (int)(Math.random() * (double)(this.rows - 1));
    }

    private static boolean shouldStartWithText() {
        return (int)(Math.random() * 6.0) > 2;
    }
}

