/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.core.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class BlobCustomerProvidedKey {
    private final String key;
    private final String keySHA256;
    private final String encryptionAlgorithm = "AES256";

    public BlobCustomerProvidedKey(String key) throws NoSuchAlgorithmException {
        this.key = key;
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] encodedHash = sha256.digest(Base64.decode(key));
        this.keySHA256 = Base64.encode(encodedHash);
    }

    public BlobCustomerProvidedKey(byte[] key) throws NoSuchAlgorithmException {
        this.key = Base64.encode(key);
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] encodedHash = sha256.digest(key);
        this.keySHA256 = Base64.encode(encodedHash);
    }

    public String getKey() {
        return this.key;
    }

    public String getKeySHA256() {
        return this.keySHA256;
    }

    public String getEncryptionAlgorithm() {
        return "AES256";
    }
}

