/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.queue;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.ListResponse;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.queue.CloudQueue;
import com.microsoft.azure.storage.queue.CloudQueueClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class QueueListHandler
extends DefaultHandler {
    private final ListResponse<CloudQueue> response = new ListResponse();
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final CloudQueueClient serviceClient;
    private String queueName;
    private HashMap<String, String> metadata;

    private QueueListHandler(CloudQueueClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public static ListResponse<CloudQueue> getQueues(InputStream stream, CloudQueueClient serviceClient) throws SAXException, IOException, ParserConfigurationException {
        SAXParser saxParser = Utility.getSAXParser();
        QueueListHandler handler = new QueueListHandler(serviceClient);
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.response;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("Queue".equals(localName)) {
            this.queueName = "";
            this.metadata = new HashMap();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String parentNode = null;
        if (!this.elementStack.isEmpty()) {
            parentNode = this.elementStack.peek();
        }
        if ((value = this.bld.toString()).isEmpty()) {
            value = null;
        }
        if ("Queue".equals(currentNode)) {
            try {
                CloudQueue queue = this.serviceClient.getQueueReference(this.queueName);
                queue.setMetadata(this.metadata);
                this.response.getResults().add(queue);
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
            catch (StorageException e) {
                throw new SAXException(e);
            }
        } else if ("EnumerationResults".equals(parentNode)) {
            if ("Prefix".equals(currentNode)) {
                this.response.setPrefix(value);
            } else if ("Marker".equals(currentNode)) {
                this.response.setMarker(value);
            } else if ("NextMarker".equals(currentNode)) {
                this.response.setNextMarker(value);
            } else if ("MaxResults".equals(currentNode)) {
                this.response.setMaxResults(Integer.parseInt(value));
            }
        } else if ("Metadata".equals(parentNode)) {
            this.metadata.put(currentNode, value);
        } else if ("Queue".equals(parentNode) && "Name".equals(currentNode)) {
            this.queueName = value;
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }
}

