/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.util;

import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class SetBasedExceptionDecision
implements ExceptionDecision {
    private final SetOfThrowables consideredFailure;
    private final SetOfThrowables consideredExpected;
    private final boolean inspectCauseChain;

    public SetBasedExceptionDecision(SetOfThrowables consideredFailure, SetOfThrowables consideredExpected, boolean inspectCauseChain) {
        this.consideredFailure = Preconditions.checkNotNull(consideredFailure, "Set of considered-failure throwables must be set");
        this.consideredExpected = Preconditions.checkNotNull(consideredExpected, "Set of considered-expected throwables must be set");
        this.inspectCauseChain = inspectCauseChain;
    }

    @Override
    public boolean isConsideredExpected(Throwable e) {
        if (this.consideredExpected.includes(e.getClass())) {
            return true;
        }
        if (this.consideredFailure.includes(e.getClass())) {
            return false;
        }
        if (!this.inspectCauseChain) {
            return true;
        }
        if (this.includes(this.consideredExpected, e)) {
            return true;
        }
        return !this.includes(this.consideredFailure, e);
    }

    private boolean includes(SetOfThrowables set, Throwable e) {
        Set alreadySeen = Collections.newSetFromMap(new IdentityHashMap());
        while (e != null && !alreadySeen.contains(e)) {
            alreadySeen.add(e);
            if (set.includes(e.getClass())) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }
}

