/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.BinderServiceUtil;
import org.wildfly.extension.messaging.activemq.Capabilities;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.JGroupsDiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastCommandDispatcherFactory;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryType;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ExternalConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final ExternalConnectionFactoryAdd INSTANCE = new ExternalConnectionFactoryAdd();

    private ExternalConnectionFactoryAdd() {
        super(ExternalConnectionFactoryDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ExternalConnectionFactoryService service;
        String name = context.getCurrentAddressValue();
        ServiceName serviceName = ExternalConnectionFactoryDefinition.CAPABILITY.getCapabilityServiceName(context.getCurrentAddress());
        boolean ha = CommonAttributes.HA.resolveModelAttribute(context, model).asBoolean();
        boolean enable1Prefixes = ConnectionFactoryAttributes.External.ENABLE_AMQ1_PREFIX.resolveModelAttribute(context, model).asBoolean();
        ModelNode discoveryGroupName = ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.resolveModelAttribute(context, model);
        ConnectionFactoryConfiguration config = ConnectionFactoryAdd.createConfiguration(context, name, model);
        JMSFactoryType jmsFactoryType = ConnectionFactoryType.valueOf(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.resolveModelAttribute(context, model).asString()).getType();
        List connectorNames = ConnectionFactoryAttributes.Common.CONNECTORS.unwrap((ExpressionResolver)context, model);
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName).addAliases(new ServiceName[]{JMSServices.getConnectionFactoryBaseServiceName(MessagingServices.getActiveMQServiceName()).append(new String[]{name})});
        if (discoveryGroupName.isDefined()) {
            ModelNode discoveryGroupModel;
            HashMap<String, String> clusterNames = new HashMap<String, String>();
            HashMap<String, Supplier<SocketBinding>> groupBindings = new HashMap<String, Supplier<SocketBinding>>();
            HashMap<String, Supplier<BroadcastCommandDispatcherFactory>> commandDispatcherFactories = new HashMap<String, Supplier<BroadcastCommandDispatcherFactory>>();
            String dgname = discoveryGroupName.asString();
            String key = "discovery" + dgname;
            try {
                discoveryGroupModel = context.readResourceFromRoot(context.getCurrentAddress().getParent().append("jgroups-discovery-group", dgname)).getModel();
            }
            catch (Resource.NoSuchResourceException ex) {
                discoveryGroupModel = new ModelNode();
            }
            if (discoveryGroupModel.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName())) {
                ModelNode channel = JGroupsDiscoveryGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, discoveryGroupModel);
                ServiceName commandDispatcherFactoryServiceName = MessagingServices.getBroadcastCommandDispatcherFactoryServiceName(channel.asStringOrNull());
                Supplier commandDispatcherFactorySupplier = builder.requires(commandDispatcherFactoryServiceName);
                commandDispatcherFactories.put(key, commandDispatcherFactorySupplier);
                String clusterName = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, discoveryGroupModel).asString();
                clusterNames.put(key, clusterName);
            } else {
                ServiceName groupBinding = GroupBindingService.getDiscoveryBaseServiceName(MessagingServices.getActiveMQServiceName()).append(new String[]{dgname});
                Supplier groupBindingSupplier = builder.requires(groupBinding);
                groupBindings.put(key, groupBindingSupplier);
            }
            service = new ExternalConnectionFactoryService(ExternalConnectionFactoryAdd.getDiscoveryGroup(context, dgname), commandDispatcherFactories, groupBindings, clusterNames, jmsFactoryType, ha, enable1Prefixes, config);
        } else {
            HashMap<String, Supplier<SocketBinding>> socketBindings = new HashMap<String, Supplier<SocketBinding>>();
            HashMap<String, Supplier<OutboundSocketBinding>> outboundSocketBindings = new HashMap<String, Supplier<OutboundSocketBinding>>();
            HashSet<String> connectorsSocketBindings = new HashSet<String>();
            HashSet<String> sslContextNames = new HashSet<String>();
            TransportConfiguration[] transportConfigurations = TransportConfigOperationHandlers.processConnectors(context, connectorNames, connectorsSocketBindings, sslContextNames);
            Map<String, Boolean> outbounds = TransportConfigOperationHandlers.listOutBoundSocketBinding(context, connectorsSocketBindings);
            for (String connectorSocketBinding : connectorsSocketBindings) {
                if (outbounds.get(connectorSocketBinding).booleanValue()) {
                    ServiceName outboundSocketName = Capabilities.OUTBOUND_SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(new String[]{connectorSocketBinding});
                    Supplier outboundSupplier = builder.requires(outboundSocketName);
                    outboundSocketBindings.put(connectorSocketBinding, outboundSupplier);
                    continue;
                }
                ServiceName socketName = Capabilities.SOCKET_BINDING_CAPABILITY.getCapabilityServiceName(new String[]{connectorSocketBinding});
                Supplier socketBindingsSupplier = builder.requires(socketName);
                socketBindings.put(connectorSocketBinding, socketBindingsSupplier);
            }
            HashMap<String, Supplier<SSLContext>> sslContexts = new HashMap<String, Supplier<SSLContext>>();
            for (String entry : sslContextNames) {
                Supplier sslContext = builder.requires(Capabilities.ELYTRON_SSL_CONTEXT_CAPABILITY.getCapabilityServiceName(new String[]{entry}));
                sslContexts.put(entry, sslContext);
            }
            service = new ExternalConnectionFactoryService(transportConfigurations, socketBindings, outboundSocketBindings, sslContexts, jmsFactoryType, ha, enable1Prefixes, config);
        }
        builder.setInstance((Service)service);
        builder.install();
        for (String entry : ConnectionFactoryAttributes.Common.ENTRIES.unwrap((ExpressionResolver)context, model)) {
            MessagingLogger.ROOT_LOGGER.debugf("Referencing %s with JNDI name %s", (Object)serviceName, (Object)entry);
            BinderServiceUtil.installBinderService(context.getServiceTarget(), entry, service, serviceName);
        }
    }

    static DiscoveryGroupConfiguration getDiscoveryGroup(OperationContext context, String name) throws OperationFailedException {
        Resource discoveryGroup;
        try {
            discoveryGroup = context.readResourceFromRoot(context.getCurrentAddress().getParent().append(new PathElement[]{PathElement.pathElement((String)"jgroups-discovery-group", (String)name)}), true);
        }
        catch (Resource.NoSuchResourceException ex) {
            discoveryGroup = context.readResourceFromRoot(context.getCurrentAddress().getParent().append(new PathElement[]{PathElement.pathElement((String)"socket-discovery-group", (String)name)}), true);
        }
        if (discoveryGroup != null) {
            long refreshTimeout = DiscoveryGroupDefinition.REFRESH_TIMEOUT.resolveModelAttribute(context, discoveryGroup.getModel()).asLong();
            long initialWaitTimeout = DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT.resolveModelAttribute(context, discoveryGroup.getModel()).asLong();
            return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout);
        }
        return null;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            if (ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST.equals(attr)) {
                if (!operation.hasDefined(ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST.getName())) continue;
                ConnectionFactoryAttributes.Common.DESERIALIZATION_BLOCKLIST.validateAndSet(operation, model);
                continue;
            }
            if (ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST.equals(attr)) {
                if (!operation.hasDefined(ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST.getName())) continue;
                ConnectionFactoryAttributes.Common.DESERIALIZATION_ALLOWLIST.validateAndSet(operation, model);
                continue;
            }
            attr.validateAndSet(operation, model);
        }
    }
}

