/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.client;

import jakarta.transaction.TransactionManager;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.management.ObjectName;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.StreamingRemoteCache;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.RemoteCacheSupport;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.operations.RetryAwareCompletionStage;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorCollection;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.commons.util.IntSet;
import org.infinispan.query.dsl.Query;
import org.reactivestreams.Publisher;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;

public class ManagedRemoteCache<K, V>
extends RemoteCacheSupport<K, V>
implements InternalRemoteCache<K, V>,
UnaryOperator<Registration> {
    private final Registrar<String> registrar;
    private final AtomicReference<Registration> registration;
    private final RemoteCacheContainer container;
    private final RemoteCacheManager manager;
    private final InternalRemoteCache<K, V> cache;

    public ManagedRemoteCache(RemoteCacheContainer container, RemoteCacheManager manager, RemoteCache<K, V> cache, Registrar<String> registrar) {
        this(container, manager, (InternalRemoteCache)cache, registrar, new AtomicReference<Registration>());
    }

    private ManagedRemoteCache(RemoteCacheContainer container, RemoteCacheManager manager, InternalRemoteCache<K, V> cache, Registrar<String> registrar, AtomicReference<Registration> registration) {
        this.container = container;
        this.manager = manager;
        this.cache = cache;
        this.registrar = registrar;
        this.registration = registration;
    }

    public boolean isTransactional() {
        return this.cache.isTransactional();
    }

    public TransactionManager getTransactionManager() {
        return this.cache.getTransactionManager();
    }

    public void start() {
        if (this.registration.getAndUpdate(this) == null) {
            this.cache.start();
        }
    }

    @Override
    public Registration apply(Registration registration) {
        return registration == null ? this.registrar.register((Object)this.getName()) : registration;
    }

    public void stop() {
        try (Registration registration = this.registration.getAndSet(null);){
            if (registration != null) {
                this.cache.stop();
            }
        }
    }

    public RemoteCacheContainer getRemoteCacheContainer() {
        return this.container;
    }

    @Deprecated
    public RemoteCacheManager getRemoteCacheManager() {
        return this.manager;
    }

    public void addClientListener(Object listener) {
        this.cache.addClientListener(listener);
    }

    public void addClientListener(Object listener, Object[] filterFactoryParams, Object[] converterFactoryParams) {
        this.cache.addClientListener(listener, filterFactoryParams, converterFactoryParams);
    }

    public ClientStatistics clientStatistics() {
        return this.cache.clientStatistics();
    }

    public CloseableIteratorSet<Map.Entry<K, V>> entrySet(IntSet segments) {
        return this.cache.entrySet(segments);
    }

    public <T> T execute(String taskName, Map<String, ?> params) {
        return (T)this.cache.execute(taskName, params);
    }

    public CacheTopologyInfo getCacheTopologyInfo() {
        return this.cache.getCacheTopologyInfo();
    }

    public DataFormat getDataFormat() {
        return this.cache.getDataFormat();
    }

    @Deprecated
    public Set<Object> getListeners() {
        return this.cache.getListeners();
    }

    public String getProtocolVersion() {
        return this.cache.getProtocolVersion();
    }

    public CloseableIteratorSet<K> keySet(IntSet segments) {
        return this.cache.keySet(segments);
    }

    public void removeClientListener(Object listener) {
        this.cache.removeClientListener(listener);
    }

    public CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, long lifespanSeconds, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return this.cache.replaceWithVersionAsync(key, newValue, version, lifespanSeconds, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
    }

    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntries(String filterConverterFactory, Object[] filterConverterParams, Set<Integer> segments, int batchSize) {
        return this.cache.retrieveEntries(filterConverterFactory, filterConverterParams, segments, batchSize);
    }

    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntriesByQuery(Query<?> filterQuery, Set<Integer> segments, int batchSize) {
        return this.cache.retrieveEntriesByQuery(filterQuery, segments, batchSize);
    }

    public CloseableIterator<Map.Entry<Object, MetadataValue<Object>>> retrieveEntriesWithMetadata(Set<Integer> segments, int batchSize) {
        return this.cache.retrieveEntriesWithMetadata(segments, batchSize);
    }

    public <E> Publisher<Map.Entry<K, E>> publishEntries(String filterConverterFactory, Object[] filterConverterParams, Set<Integer> segments, int batchSize) {
        return this.cache.publishEntries(filterConverterFactory, filterConverterParams, segments, batchSize);
    }

    public <E> Publisher<Map.Entry<K, E>> publishEntriesByQuery(Query<?> filterQuery, Set<Integer> segments, int batchSize) {
        return this.cache.publishEntriesByQuery(filterQuery, segments, batchSize);
    }

    public Publisher<Map.Entry<K, MetadataValue<V>>> publishEntriesWithMetadata(Set<Integer> segments, int batchSize) {
        return this.cache.publishEntriesWithMetadata(segments, batchSize);
    }

    public ServerStatistics serverStatistics() {
        return this.cache.serverStatistics();
    }

    public StreamingRemoteCache<K> streaming() {
        return this.cache.streaming();
    }

    public CloseableIteratorCollection<V> values(IntSet segments) {
        return this.cache.values(segments);
    }

    public <T, U> InternalRemoteCache<T, U> withDataFormat(DataFormat dataFormat) {
        return new ManagedRemoteCache<K, V>(this.container, this.manager, this.cache.withDataFormat(dataFormat), this.registrar, this.registration);
    }

    public InternalRemoteCache<K, V> withFlags(Flag ... flags) {
        return new ManagedRemoteCache<K, V>(this.container, this.manager, this.cache.withFlags(flags), this.registrar, this.registration);
    }

    public String getName() {
        return this.cache.getName();
    }

    public String getVersion() {
        return this.cache.getVersion();
    }

    public CompletableFuture<Void> clearAsync() {
        return this.cache.clearAsync();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<Boolean> containsKeyAsync(K key) {
        return this.cache.containsKeyAsync(key);
    }

    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return this.cache.getAllAsync(keys);
    }

    public CompletableFuture<V> getAsync(K key) {
        return this.cache.getAsync(key);
    }

    public CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K key) {
        return this.cache.getWithMetadataAsync(key);
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> removeAsync(Object key) {
        return this.cache.removeAsync(key);
    }

    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return this.cache.removeAsync(key, value);
    }

    public CompletableFuture<Boolean> removeWithVersionAsync(K key, long version) {
        return this.cache.removeWithVersionAsync(key, version);
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.cache.replaceAll(function);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<Long> sizeAsync() {
        return this.cache.sizeAsync();
    }

    public CompletionStage<ServerStatistics> serverStatisticsAsync() {
        return this.cache.serverStatisticsAsync();
    }

    public CloseableIterator<K> keyIterator(IntSet segments) {
        return this.cache.keyIterator(segments);
    }

    public CloseableIterator<Map.Entry<K, V>> entryIterator(IntSet segments) {
        return this.cache.entryIterator(segments);
    }

    public RetryAwareCompletionStage<MetadataValue<V>> getWithMetadataAsync(K key, SocketAddress preferredAddress) {
        return this.cache.getWithMetadataAsync(key, preferredAddress);
    }

    public boolean hasForceReturnFlag() {
        return this.cache.hasForceReturnFlag();
    }

    public void resolveStorage(boolean objectStorage) {
        this.cache.resolveStorage(objectStorage);
    }

    public void init(OperationsFactory operationsFactory, Configuration configuration, ObjectName jmxParent) {
        this.cache.init(operationsFactory, configuration, jmxParent);
    }

    public void init(OperationsFactory operationsFactory, Configuration configuration) {
        this.cache.init(operationsFactory, configuration);
    }

    public OperationsFactory getOperationsFactory() {
        return this.cache.getOperationsFactory();
    }

    public boolean isObjectStorage() {
        return this.cache.isObjectStorage();
    }

    public K keyAsObjectIfNeeded(Object key) {
        return (K)this.cache.keyAsObjectIfNeeded(key);
    }

    public byte[] keyToBytes(Object object) {
        return this.cache.keyToBytes(object);
    }

    public CompletionStage<PingResponse> ping() {
        return this.cache.ping();
    }

    public SocketAddress addNearCacheListener(Object listener, int bloomBits) {
        return this.cache.addNearCacheListener(listener, bloomBits);
    }

    public CompletionStage<Void> updateBloomFilter() {
        return this.cache.updateBloomFilter();
    }
}

