/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.session.hotrod;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.near.NearCacheFactory;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.infinispan.client.service.RemoteCacheServiceConfigurator;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.SessionManagerNearCacheFactory;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.extension.clustering.web.session.hotrod.HotRodSessionManagementConfiguration;

public class HotRodSessionManagerFactoryServiceConfigurator<S, SC, AL, LC>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
HotRodSessionManagerFactoryConfiguration<S, SC, AL, LC>,
Supplier<SessionManagerFactory<SC, LC, TransactionBatch>> {
    private final HotRodSessionManagementConfiguration<DeploymentUnit> configuration;
    private final SessionManagerFactoryConfiguration<S, SC, AL, LC> factoryConfiguration;
    private volatile ServiceConfigurator cacheConfigurator;
    private volatile SupplierDependency<RemoteCache> cache;

    public HotRodSessionManagerFactoryServiceConfigurator(HotRodSessionManagementConfiguration<DeploymentUnit> configuration, SessionManagerFactoryConfiguration<S, SC, AL, LC> factoryConfiguration) {
        super(ServiceName.JBOSS.append(new String[]{"clustering", "web", factoryConfiguration.getDeploymentName()}));
        this.configuration = configuration;
        this.factoryConfiguration = factoryConfiguration;
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        final Integer maxActiveSessions = this.getMaxActiveSessions();
        final NearCacheMode mode = maxActiveSessions == null || maxActiveSessions == 0 ? NearCacheMode.DISABLED : NearCacheMode.INVALIDATED;
        String configurationName = this.configuration.getConfigurationName();
        final String templateName = configurationName != null ? configurationName : DefaultTemplate.DIST_SYNC.getTemplateName();
        final SessionAttributePersistenceStrategy strategy = this.getAttributePersistenceStrategy();
        this.cacheConfigurator = new RemoteCacheServiceConfigurator(this.getServiceName().append(new String[]{"cache"}), this.configuration.getContainerName(), this.getDeploymentName(), (Consumer)new Consumer<RemoteCacheConfigurationBuilder>(){

            @Override
            public void accept(RemoteCacheConfigurationBuilder builder) {
                builder.forceReturnValues(false).nearCacheMode(mode).templateName(templateName).transactionMode(TransactionMode.NONE).nearCacheFactory((NearCacheFactory)new SessionManagerNearCacheFactory(maxActiveSessions, strategy));
            }
        }).configure(support);
        this.cache = new ServiceSupplierDependency(this.cacheConfigurator.getServiceName());
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        this.cacheConfigurator.build(target).install();
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = this.cache.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(factory, Function.identity(), (Supplier)this, Consumers.close());
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public SessionManagerFactory<SC, LC, TransactionBatch> get() {
        return new HotRodSessionManagerFactory((HotRodSessionManagerFactoryConfiguration)this);
    }

    public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
        return this.factoryConfiguration.getAttributePersistenceStrategy();
    }

    public ByteBufferMarshaller getMarshaller() {
        return this.factoryConfiguration.getMarshaller();
    }

    public Integer getMaxActiveSessions() {
        return this.factoryConfiguration.getMaxActiveSessions();
    }

    public LocalContextFactory<LC> getLocalContextFactory() {
        return this.factoryConfiguration.getLocalContextFactory();
    }

    public String getServerName() {
        return this.factoryConfiguration.getServerName();
    }

    public String getDeploymentName() {
        return this.factoryConfiguration.getDeploymentName();
    }

    public Immutability getImmutability() {
        return this.factoryConfiguration.getImmutability();
    }

    public <K, V> RemoteCache<K, V> getCache() {
        return (RemoteCache)this.cache.get();
    }

    public SpecificationProvider<S, SC, AL> getSpecificationProvider() {
        return this.factoryConfiguration.getSpecificationProvider();
    }
}

