/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.io.Serializable;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import org.wildfly.common.Assert;

public final class OneTimePasswordAlgorithmSpec
implements AlgorithmParameterSpec,
Serializable {
    private static final long serialVersionUID = 2703192508293746122L;
    private final String algorithm;
    private final String seed;
    private final int sequenceNumber;

    public OneTimePasswordAlgorithmSpec(String algorithm, String seed, int sequenceNumber) {
        Assert.checkNotNullParam("algorithm", algorithm);
        Assert.checkNotNullParam("seed", seed);
        this.algorithm = algorithm;
        this.seed = seed;
        this.sequenceNumber = sequenceNumber;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getSeed() {
        return this.seed;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean equals(Object other) {
        if (!(other instanceof OneTimePasswordAlgorithmSpec)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        OneTimePasswordAlgorithmSpec otherSpec = (OneTimePasswordAlgorithmSpec)other;
        return this.sequenceNumber == otherSpec.sequenceNumber && Objects.equals(this.algorithm, otherSpec.algorithm) && Objects.equals(this.seed, otherSpec.seed);
    }

    public int hashCode() {
        return (this.sequenceNumber * 31 + this.seed.hashCode()) * 31 + this.algorithm.hashCode();
    }
}

