/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.NameServiceStartThread;
import com.sun.corba.se.impl.activation.RepositoryImpl;
import com.sun.corba.se.impl.activation.ServerManagerImpl;
import com.sun.corba.se.impl.legacy.connection.SocketFactoryAcceptorImpl;
import com.sun.corba.se.impl.naming.cosnaming.TransientNameService;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.impl.transport.SocketOrChannelAcceptorImpl;
import com.sun.corba.se.spi.activation.Activator;
import com.sun.corba.se.spi.activation.ActivatorHelper;
import com.sun.corba.se.spi.activation.Locator;
import com.sun.corba.se.spi.activation.LocatorHelper;
import com.sun.corba.se.spi.activation.Repository;
import com.sun.corba.se.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.se.spi.orb.ORB;
import java.io.File;
import java.util.Properties;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;

public class ORBD {
    private int initSvcPort;
    protected File dbDir;
    private String dbDirName;
    protected Locator locator;
    protected Activator activator;
    protected RepositoryImpl repository;
    private static String[][] orbServers = new String[][]{{""}};

    protected void initializeBootNaming(ORB orb) {
        this.initSvcPort = orb.getORBData().getORBInitialPort();
        SocketOrChannelAcceptorImpl acceptor = orb.getORBData().getLegacySocketFactory() == null ? new SocketOrChannelAcceptorImpl(orb, this.initSvcPort, "BOOT_NAMING", "IIOP_CLEAR_TEXT") : new SocketFactoryAcceptorImpl(orb, this.initSvcPort, "BOOT_NAMING", "IIOP_CLEAR_TEXT");
        orb.getCorbaTransportManager().registerAcceptor(acceptor);
    }

    protected ORB createORB(String[] args) {
        Properties props = System.getProperties();
        props.put("com.sun.CORBA.POA.ORBServerId", "1000");
        props.put("com.sun.CORBA.POA.ORBPersistentServerPort", props.getProperty("com.sun.CORBA.activation.Port", Integer.toString(1049)));
        props.put("org.omg.CORBA.ORBClass", "com.sun.corba.se.impl.orb.ORBImpl");
        return (ORB)ORB.init(args, props);
    }

    private void run(String[] args) {
        try {
            this.processArgs(args);
            ORB orb = this.createORB(args);
            if (orb.orbdDebugFlag) {
                System.out.println("ORBD begins initialization.");
            }
            boolean firstRun = this.createSystemDirs("orb.db");
            this.startActivationObjects(orb);
            if (firstRun) {
                this.installOrbServers(this.getRepository(), this.getActivator());
            }
            if (orb.orbdDebugFlag) {
                System.out.println("ORBD is ready.");
                System.out.println("ORBD serverid: " + System.getProperty("com.sun.CORBA.POA.ORBServerId"));
                System.out.println("activation dbdir: " + System.getProperty("com.sun.CORBA.activation.DbDir"));
                System.out.println("activation port: " + System.getProperty("com.sun.CORBA.activation.Port"));
                String pollingTime = System.getProperty("com.sun.CORBA.activation.ServerPollingTime");
                if (pollingTime == null) {
                    pollingTime = Integer.toString(1000);
                }
                System.out.println("activation Server Polling Time: " + pollingTime + " milli-seconds ");
                String startupDelay = System.getProperty("com.sun.CORBA.activation.ServerStartupDelay");
                if (startupDelay == null) {
                    startupDelay = Integer.toString(1000);
                }
                System.out.println("activation Server Startup Delay: " + startupDelay + " milli-seconds ");
            }
            NameServiceStartThread theThread = new NameServiceStartThread(orb, this.dbDir);
            theThread.start();
            orb.run();
        }
        catch (COMM_FAILURE cex) {
            System.out.println(CorbaResourceUtil.getText("orbd.commfailure"));
            System.out.println(cex);
            cex.printStackTrace();
        }
        catch (INTERNAL iex) {
            System.out.println(CorbaResourceUtil.getText("orbd.internalexception"));
            System.out.println(iex);
            iex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
            System.out.println(ex);
            ex.printStackTrace();
        }
    }

    private void processArgs(String[] args) {
        Properties props = System.getProperties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-port")) {
                if (i + 1 < args.length) {
                    props.put("com.sun.CORBA.activation.Port", args[++i]);
                    continue;
                }
                System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                continue;
            }
            if (args[i].equals("-defaultdb")) {
                if (i + 1 < args.length) {
                    props.put("com.sun.CORBA.activation.DbDir", args[++i]);
                    continue;
                }
                System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                continue;
            }
            if (args[i].equals("-serverid")) {
                if (i + 1 < args.length) {
                    props.put("com.sun.CORBA.POA.ORBServerId", args[++i]);
                    continue;
                }
                System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                continue;
            }
            if (args[i].equals("-serverPollingTime")) {
                if (i + 1 < args.length) {
                    props.put("com.sun.CORBA.activation.ServerPollingTime", args[++i]);
                    continue;
                }
                System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                continue;
            }
            if (!args[i].equals("-serverStartupDelay")) continue;
            if (i + 1 < args.length) {
                props.put("com.sun.CORBA.activation.ServerStartupDelay", args[++i]);
                continue;
            }
            System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
        }
    }

    protected boolean createSystemDirs(String defaultDbDir) {
        File logDir;
        boolean dirCreated = false;
        Properties props = System.getProperties();
        String fileSep = props.getProperty("file.separator");
        this.dbDir = new File(props.getProperty("com.sun.CORBA.activation.DbDir", props.getProperty("user.dir") + fileSep + defaultDbDir));
        this.dbDirName = this.dbDir.getAbsolutePath();
        props.put("com.sun.CORBA.activation.DbDir", this.dbDirName);
        if (!this.dbDir.exists()) {
            this.dbDir.mkdir();
            dirCreated = true;
        }
        if (!(logDir = new File(this.dbDir, "logs")).exists()) {
            logDir.mkdir();
        }
        return dirCreated;
    }

    protected File getDbDir() {
        return this.dbDir;
    }

    protected String getDbDirName() {
        return this.dbDirName;
    }

    protected void startActivationObjects(ORB orb) throws Exception {
        this.initializeBootNaming(orb);
        this.repository = new RepositoryImpl(orb, this.dbDir, orb.orbdDebugFlag);
        orb.register_initial_reference("ServerRepository", (Object)((java.lang.Object)this.repository));
        ServerManagerImpl serverMgr = new ServerManagerImpl(orb, orb.getCorbaTransportManager(), (Repository)((java.lang.Object)this.repository), this.getDbDirName(), orb.orbdDebugFlag);
        this.locator = LocatorHelper.narrow((Object)((java.lang.Object)serverMgr));
        orb.register_initial_reference("ServerLocator", this.locator);
        this.activator = ActivatorHelper.narrow((Object)((java.lang.Object)serverMgr));
        orb.register_initial_reference("ServerActivator", this.activator);
        TransientNameService nameService = new TransientNameService(orb, "TNameService");
    }

    protected Locator getLocator() {
        return this.locator;
    }

    protected Activator getActivator() {
        return this.activator;
    }

    protected RepositoryImpl getRepository() {
        return this.repository;
    }

    protected void installOrbServers(RepositoryImpl repository, Activator activator) {
        for (int i = 0; i < orbServers.length; ++i) {
            try {
                String[] server = orbServers[i];
                ServerDef serverDef = new ServerDef(server[1], server[2], server[3], server[4], server[5]);
                int serverId = Integer.valueOf(orbServers[i][0]);
                repository.registerServer(serverDef, serverId);
                activator.activate(serverId);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        ORBD orbd = new ORBD();
        orbd.run(args);
    }
}

