/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.ior;

import com.sun.corba.se.impl.ior.EncapsulationUtility;
import com.sun.corba.se.spi.ior.Identifiable;
import java.util.Arrays;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public abstract class GenericIdentifiable
implements Identifiable {
    private int id;
    private byte[] data;

    public GenericIdentifiable(int id, InputStream is) {
        this.id = id;
        this.data = EncapsulationUtility.readOctets(is);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void write(OutputStream os) {
        os.write_ulong(this.data.length);
        os.write_octet_array(this.data, 0, this.data.length);
    }

    public String toString() {
        return "GenericIdentifiable[id=" + this.getId() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericIdentifiable)) {
            return false;
        }
        GenericIdentifiable encaps = (GenericIdentifiable)obj;
        return this.getId() == encaps.getId() && Arrays.equals(this.getData(), encaps.getData());
    }

    public int hashCode() {
        int result = 17;
        for (int ctr = 0; ctr < this.data.length; ++ctr) {
            result = 37 * result + this.data[ctr];
        }
        return result;
    }

    public GenericIdentifiable(int id, byte[] data) {
        this.id = id;
        this.data = (byte[])data.clone();
    }

    public byte[] getData() {
        return this.data;
    }
}

