/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import java.util.Objects;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.type.Type;

public class PropertyData {
    private final String name;
    private final String beanName;
    private final String accessType;
    private boolean usingModifiedFlag;
    private String modifiedFlagName;
    private boolean synthetic;
    private Type propertyType;
    private Class<?> virtualReturnClass;
    private PropertyAccessStrategy propertyAccessStrategy;

    public PropertyData(String newName, PropertyData propertyData) {
        this.name = newName;
        this.beanName = propertyData.beanName;
        this.accessType = propertyData.accessType;
        this.usingModifiedFlag = propertyData.usingModifiedFlag;
        this.modifiedFlagName = propertyData.modifiedFlagName;
        this.synthetic = propertyData.synthetic;
        this.propertyType = propertyData.propertyType;
        this.virtualReturnClass = propertyData.virtualReturnClass;
    }

    public PropertyData(String name, String beanName, String accessType) {
        this.name = name;
        this.beanName = beanName;
        this.accessType = accessType;
    }

    public PropertyData(String name, String beanName, String accessType, Type propertyType) {
        this(name, beanName, accessType);
        this.propertyType = propertyType;
    }

    public PropertyData(String name, String beanName, String accessType, boolean usingModifiedFlag, String modifiedFlagName, boolean synthetic) {
        this(name, beanName, accessType);
        this.usingModifiedFlag = usingModifiedFlag;
        this.modifiedFlagName = modifiedFlagName;
        this.synthetic = synthetic;
    }

    public PropertyData(String name, String beanName, String accessType, boolean usingModifiedFlag, String modifiedFlagName, boolean synthetic, Type propertyType, PropertyAccessStrategy propertyAccessStrategy) {
        this(name, beanName, accessType, usingModifiedFlag, modifiedFlagName, synthetic, propertyType, null, propertyAccessStrategy);
    }

    public PropertyData(String name, String beanName, String accessType, boolean usingModifiedFlag, String modifiedFlagName, boolean synthetic, Type propertyType, Class<?> virtualReturnClass, PropertyAccessStrategy propertyAccessStrategy) {
        this(name, beanName, accessType, usingModifiedFlag, modifiedFlagName, synthetic);
        this.propertyType = propertyType;
        this.virtualReturnClass = virtualReturnClass;
        this.propertyAccessStrategy = propertyAccessStrategy;
    }

    public String getName() {
        return this.name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public boolean isUsingModifiedFlag() {
        return this.usingModifiedFlag;
    }

    public String getModifiedFlagPropertyName() {
        return this.modifiedFlagName;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public Type getType() {
        return this.propertyType;
    }

    public Class<?> getVirtualReturnClass() {
        return this.virtualReturnClass;
    }

    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.propertyAccessStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyData that = (PropertyData)o;
        return this.usingModifiedFlag == that.usingModifiedFlag && Objects.equals(this.accessType, that.accessType) && Objects.equals(this.beanName, that.beanName) && Objects.equals(this.name, that.name) && Objects.equals(this.synthetic, that.synthetic);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.beanName != null ? this.beanName.hashCode() : 0);
        result = 31 * result + (this.accessType != null ? this.accessType.hashCode() : 0);
        result = 31 * result + (this.usingModifiedFlag ? 1 : 0);
        result = 31 * result + (this.synthetic ? 1 : 0);
        return result;
    }

    public static PropertyData forProperty(String propertyName, Type propertyType) {
        return new PropertyData(propertyName, null, null, propertyType);
    }
}

