/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategy;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategyInitializationContext;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ShardingStrategyInitializationContextImpl
implements ShardingStrategyInitializationContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<BeanReference<? extends ShardingStrategy>> SHARDING_STRATEGY = ConfigurationProperty.forKey((String)"strategy").asBeanReference(ShardingStrategy.class).withDefault((Object)BeanReference.of(ShardingStrategy.class, (String)"none")).build();
    private final IndexManagerBackendContext backendContext;
    private final LuceneIndexModel model;
    private final IndexManagerStartContext startContext;
    private final ConfigurationPropertySource shardingPropertySource;
    private Set<String> shardIdentifiers = new LinkedHashSet<String>();

    ShardingStrategyInitializationContextImpl(IndexManagerBackendContext backendContext, LuceneIndexModel model, IndexManagerStartContext startContext, ConfigurationPropertySource indexPropertySource) {
        this.backendContext = backendContext;
        this.model = model;
        this.startContext = startContext;
        this.shardingPropertySource = indexPropertySource.withMask("sharding");
    }

    @Override
    public void shardIdentifiers(Set<String> shardIdentifiers) {
        this.shardIdentifiers.clear();
        this.shardIdentifiers.addAll(shardIdentifiers);
    }

    @Override
    public void disableSharding() {
        this.shardIdentifiers = null;
    }

    @Override
    public String indexName() {
        return this.model.hibernateSearchName();
    }

    @Override
    public BeanResolver beanResolver() {
        return this.startContext.beanResolver();
    }

    @Override
    public ConfigurationPropertySource configurationPropertySource() {
        return this.shardingPropertySource;
    }

    public BeanHolder<? extends ShardingStrategy> create(Map<String, Shard> shardCollector) {
        BeanHolder shardingStrategyHolder = (BeanHolder)SHARDING_STRATEGY.getAndTransform(this.shardingPropertySource, arg_0 -> ((BeanResolver)this.beanResolver()).resolve(arg_0));
        ((ShardingStrategy)shardingStrategyHolder.get()).initialize(this);
        if (this.shardIdentifiers == null) {
            this.contributeShard(shardCollector, Optional.empty());
            return null;
        }
        if (this.shardIdentifiers.isEmpty()) {
            throw log.missingShardIdentifiersAfterShardingStrategyInitialization(shardingStrategyHolder.get());
        }
        for (String shardIdentifier : this.shardIdentifiers) {
            this.contributeShard(shardCollector, Optional.of(shardIdentifier));
        }
        return shardingStrategyHolder;
    }

    private void contributeShard(Map<String, Shard> shardCollector, Optional<String> shardId) {
        Shard shard = new Shard(shardId, this.backendContext, this.model);
        shardCollector.put(shardId.orElse(null), shard);
    }
}

