/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.NumericDoubleValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.SortedNumericDoubleDocValues;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.ChildDocIds;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;

public abstract class DoubleMultiValuesToSingleValuesSource
extends DoubleValuesSource {
    protected final MultiValueMode mode;
    protected final NestedDocsProvider nestedDocsProvider;

    public static DoubleMultiValuesToSingleValuesSource fromDoubleField(String field, MultiValueMode mode, NestedDocsProvider nested) {
        return DoubleMultiValuesToSingleValuesSource.fromField(field, mode, nested, SortedNumericDoubleDocValues::fromDoubleField);
    }

    public static DoubleMultiValuesToSingleValuesSource fromFloatField(String field, MultiValueMode mode, NestedDocsProvider nested) {
        return DoubleMultiValuesToSingleValuesSource.fromField(field, mode, nested, SortedNumericDoubleDocValues::fromFloatField);
    }

    private static DoubleMultiValuesToSingleValuesSource fromField(String field, MultiValueMode mode, NestedDocsProvider nested, Function<SortedNumericDocValues, SortedNumericDoubleDocValues> decoder) {
        return new FieldMultiValuesToSingleValuesSource(field, mode, nested, decoder);
    }

    public DoubleMultiValuesToSingleValuesSource(MultiValueMode mode, NestedDocsProvider nestedDocsProvider) {
        this.mode = mode;
        this.nestedDocsProvider = nestedDocsProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DoubleMultiValuesToSingleValuesSource that = (DoubleMultiValuesToSingleValuesSource)((Object)o);
        return Objects.equals((Object)this.mode, (Object)that.mode) && Objects.equals(this.nestedDocsProvider, that.nestedDocsProvider);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.nestedDocsProvider});
    }

    public NumericDoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        SortedNumericDoubleDocValues values = this.getSortedNumericDoubleDocValues(ctx);
        if (this.nestedDocsProvider == null) {
            return this.select(values);
        }
        return this.select(values, this.nestedDocsProvider.childDocs(ctx, values));
    }

    protected abstract SortedNumericDoubleDocValues getSortedNumericDoubleDocValues(LeafReaderContext var1) throws IOException;

    protected NumericDoubleValues select(final SortedNumericDoubleDocValues values) {
        NumericDoubleValues singleton = SortedNumericDoubleDocValues.unwrapSingleton(values);
        if (singleton != null) {
            return singleton;
        }
        return new NumericDoubleValues(){
            private double value;

            public double doubleValue() {
                return this.value;
            }

            public boolean advanceExact(int doc) throws IOException {
                if (values.advanceExact(doc)) {
                    this.value = DoubleMultiValuesToSingleValuesSource.this.mode.pick(values);
                    return true;
                }
                return false;
            }
        };
    }

    protected NumericDoubleValues select(final SortedNumericDoubleDocValues values, final ChildDocIds childDocsWithValues) {
        if (childDocsWithValues == null) {
            return NumericDoubleValues.EMPTY;
        }
        return new NumericDoubleValues(){
            int lastSeenParentDoc = -1;
            double lastEmittedValue = -1.0;

            public double doubleValue() {
                return this.lastEmittedValue;
            }

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                if (!childDocsWithValues.advanceExactParent(parentDoc)) {
                    return false;
                }
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = DoubleMultiValuesToSingleValuesSource.this.mode.pick(values, childDocsWithValues);
                return true;
            }
        };
    }

    private static class FieldMultiValuesToSingleValuesSource
    extends DoubleMultiValuesToSingleValuesSource {
        private final String field;
        private final Function<SortedNumericDocValues, SortedNumericDoubleDocValues> decoder;

        public FieldMultiValuesToSingleValuesSource(String field, MultiValueMode mode, NestedDocsProvider nestedDocsProvider, Function<SortedNumericDocValues, SortedNumericDoubleDocValues> decoder) {
            super(mode, nestedDocsProvider);
            this.field = field;
            this.decoder = decoder;
        }

        public String toString() {
            return "double(" + this.field + "," + (Object)((Object)this.mode) + "," + this.nestedDocsProvider + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            FieldMultiValuesToSingleValuesSource that = (FieldMultiValuesToSingleValuesSource)((Object)o);
            return Objects.equals(this.field, that.field) && Objects.equals(this.decoder, that.decoder);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.field, this.decoder);
        }

        public boolean needsScores() {
            return false;
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{this.field});
        }

        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            DoubleValues values = this.getValues(ctx, null);
            if (values.advanceExact(docId)) {
                return Explanation.match((Number)values.doubleValue(), (String)this.toString(), (Explanation[])new Explanation[0]);
            }
            return Explanation.noMatch((String)this.toString(), (Explanation[])new Explanation[0]);
        }

        public DoubleValuesSource rewrite(IndexSearcher searcher) {
            return this;
        }

        @Override
        protected SortedNumericDoubleDocValues getSortedNumericDoubleDocValues(LeafReaderContext ctx) throws IOException {
            return this.decoder.apply(DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.field));
        }
    }
}

