/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.spi;

import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.hibernate.engine.jdbc.mutation.spi.Binding;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;

public class BindingGroup {
    private final String tableName;
    private final Set<Binding> bindings;

    public BindingGroup(String tableName) {
        this.tableName = tableName;
        this.bindings = new TreeSet<Binding>(Comparator.comparing(Binding::getPosition));
    }

    public String getTableName() {
        return this.tableName;
    }

    public Set<Binding> getBindings() {
        return this.bindings;
    }

    public void forEachBinding(Consumer<Binding> action) {
        this.bindings.forEach(action);
    }

    public void bindValue(String columnName, Object value, JdbcValueDescriptor valueDescriptor) {
        assert (Objects.equals(columnName, valueDescriptor.getColumnName()));
        this.bindings.add(new Binding(columnName, value, valueDescriptor));
    }

    public void clear() {
        this.bindings.clear();
    }
}

