/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.RollbackException;
import java.io.Serializable;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.query.sqm.ParsingException;

public class ExceptionConverterImpl
implements ExceptionConverter {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(ExceptionConverterImpl.class);
    private final SharedSessionContractImplementor sharedSessionContract;
    private final boolean isJpaBootstrap;

    public ExceptionConverterImpl(SharedSessionContractImplementor sharedSessionContract) {
        this.sharedSessionContract = sharedSessionContract;
        this.isJpaBootstrap = sharedSessionContract.getFactory().getSessionFactoryOptions().isJpaBootstrap();
    }

    @Override
    public RuntimeException convertCommitException(RuntimeException exception) {
        if (this.isJpaBootstrap) {
            try {
                this.sharedSessionContract.getTransaction().rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return new RollbackException("Error while committing the transaction", this.wrapCommitException(exception));
        }
        return exception;
    }

    private Throwable wrapCommitException(RuntimeException exception) {
        if (exception instanceof HibernateException) {
            return this.convert((HibernateException)((Object)exception));
        }
        if (exception instanceof PersistenceException) {
            Throwable cause;
            Throwable throwable = cause = exception.getCause() == null ? exception : exception.getCause();
            if (cause instanceof HibernateException) {
                return this.convert((HibernateException)((Object)cause));
            }
            return cause;
        }
        return exception;
    }

    @Override
    public RuntimeException convert(HibernateException exception, LockOptions lockOptions) {
        if (exception instanceof StaleStateException) {
            PersistenceException converted = this.wrapStaleStateException((StaleStateException)exception);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof LockAcquisitionException) {
            PersistenceException converted = this.wrapLockException(exception, lockOptions);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof LockingStrategyException) {
            PersistenceException converted = this.wrapLockException(exception, lockOptions);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof PessimisticLockException) {
            PersistenceException converted = this.wrapLockException(exception, lockOptions);
            this.rollbackIfNecessary(converted);
            return converted;
        }
        if (exception instanceof QueryTimeoutException) {
            jakarta.persistence.QueryTimeoutException converted = new jakarta.persistence.QueryTimeoutException(exception.getMessage(), (Throwable)((Object)exception));
            this.rollbackIfNecessary((PersistenceException)converted);
            return converted;
        }
        if (exception instanceof ObjectNotFoundException) {
            EntityNotFoundException converted = new EntityNotFoundException(exception.getMessage());
            this.rollbackIfNecessary((PersistenceException)converted);
            return converted;
        }
        if (exception instanceof NonUniqueObjectException) {
            EntityExistsException converted = new EntityExistsException(exception.getMessage());
            this.rollbackIfNecessary((PersistenceException)converted);
            return converted;
        }
        if (exception instanceof NonUniqueResultException) {
            jakarta.persistence.NonUniqueResultException converted = new jakarta.persistence.NonUniqueResultException(exception.getMessage());
            this.rollbackIfNecessary((PersistenceException)converted);
            return converted;
        }
        if (exception instanceof UnresolvableObjectException) {
            EntityNotFoundException converted = new EntityNotFoundException(exception.getMessage());
            this.rollbackIfNecessary((PersistenceException)converted);
            return converted;
        }
        if (exception instanceof QueryException || exception instanceof ParsingException) {
            return new IllegalArgumentException((Throwable)((Object)exception));
        }
        if (exception instanceof MultipleBagFetchException) {
            return new IllegalArgumentException((Throwable)((Object)exception));
        }
        if (exception instanceof TransientObjectException) {
            try {
                this.sharedSessionContract.markForRollbackOnly();
            }
            catch (Exception ne) {
                log.unableToMarkForRollbackOnTransientObjectException(ne);
            }
            return new IllegalStateException((Throwable)((Object)exception));
        }
        this.rollbackIfNecessary(exception);
        return exception;
    }

    @Override
    public RuntimeException convert(HibernateException exception) {
        return this.convert(exception, null);
    }

    @Override
    public RuntimeException convert(RuntimeException exception) {
        if (exception instanceof HibernateException) {
            return this.convert((HibernateException)((Object)exception));
        }
        this.sharedSessionContract.markForRollbackOnly();
        return exception;
    }

    @Override
    public RuntimeException convert(RuntimeException exception, LockOptions lockOptions) {
        if (exception instanceof HibernateException) {
            return this.convert((HibernateException)((Object)exception), lockOptions);
        }
        this.sharedSessionContract.markForRollbackOnly();
        return exception;
    }

    @Override
    public JDBCException convert(SQLException e, String message) {
        return this.sharedSessionContract.getJdbcServices().getSqlExceptionHelper().convert(e, message);
    }

    protected PersistenceException wrapStaleStateException(StaleStateException e) {
        if (e instanceof StaleObjectStateException) {
            StaleObjectStateException sose = (StaleObjectStateException)e;
            Object identifier = sose.getIdentifier();
            if (identifier != null) {
                try {
                    Object entity = this.sharedSessionContract.internalLoad(sose.getEntityName(), identifier, false, true);
                    if (entity instanceof Serializable) {
                        return new OptimisticLockException(e.getMessage(), (Throwable)((Object)e), entity);
                    }
                    return new OptimisticLockException(e.getMessage(), (Throwable)((Object)e));
                }
                catch (EntityNotFoundException enfe) {
                    return new OptimisticLockException(e.getMessage(), (Throwable)((Object)e));
                }
            }
            return new OptimisticLockException(e.getMessage(), (Throwable)((Object)e));
        }
        return new OptimisticLockException(e.getMessage(), (Throwable)((Object)e));
    }

    protected PersistenceException wrapLockException(HibernateException e, LockOptions lockOptions) {
        if (e instanceof OptimisticEntityLockException) {
            OptimisticEntityLockException lockException = (OptimisticEntityLockException)e;
            return new OptimisticLockException(lockException.getMessage(), (Throwable)((Object)lockException), lockException.getEntity());
        }
        if (e instanceof LockTimeoutException) {
            return new jakarta.persistence.LockTimeoutException(e.getMessage(), (Throwable)((Object)e), null);
        }
        if (e instanceof PessimisticEntityLockException) {
            PessimisticEntityLockException lockException = (PessimisticEntityLockException)e;
            if (lockOptions != null && lockOptions.getTimeOut() > -1) {
                return new jakarta.persistence.LockTimeoutException(lockException.getMessage(), (Throwable)((Object)lockException), lockException.getEntity());
            }
            return new jakarta.persistence.PessimisticLockException(lockException.getMessage(), (Throwable)((Object)lockException), lockException.getEntity());
        }
        if (e instanceof PessimisticLockException) {
            PessimisticLockException jdbcLockException = (PessimisticLockException)e;
            if (lockOptions != null && lockOptions.getTimeOut() > -1) {
                return new jakarta.persistence.LockTimeoutException(jdbcLockException.getMessage(), (Throwable)((Object)jdbcLockException), null);
            }
            return new jakarta.persistence.PessimisticLockException(jdbcLockException.getMessage(), (Throwable)((Object)jdbcLockException), null);
        }
        return new OptimisticLockException((Throwable)((Object)e));
    }

    private void rollbackIfNecessary(PersistenceException e) {
        if (!(e instanceof NoResultException || e instanceof jakarta.persistence.NonUniqueResultException || e instanceof jakarta.persistence.LockTimeoutException || e instanceof jakarta.persistence.QueryTimeoutException)) {
            try {
                this.sharedSessionContract.markForRollbackOnly();
            }
            catch (Exception ne) {
                log.unableToMarkForRollbackOnPersistenceException(ne);
            }
        }
    }
}

