/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.CustomSqlMutation;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.TableMutation;

public abstract class AbstractTableMutation<O extends MutationOperation>
implements TableMutation<O> {
    private final MutatingTableReference mutatingTable;
    private final MutationTarget<?> mutationTarget;
    private final String sqlComment;
    private final List<ColumnValueParameter> parameters;

    public AbstractTableMutation(MutatingTableReference mutatingTable, MutationTarget<?> mutationTarget, String sqlComment, List<ColumnValueParameter> parameters) {
        this.mutatingTable = mutatingTable;
        this.mutationTarget = mutationTarget;
        this.sqlComment = sqlComment;
        this.parameters = parameters;
    }

    public String toString() {
        String type = this.isCustomSql() ? "custom-sql" : "generated";
        return this.getLoggableName() + "(" + this.getMutationTarget().getRolePath() + " : " + type + ")";
    }

    public boolean isCustomSql() {
        return this instanceof CustomSqlMutation;
    }

    protected abstract String getLoggableName();

    @Override
    public MutatingTableReference getMutatingTable() {
        return this.mutatingTable;
    }

    public MutationTarget<?> getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public String getMutationComment() {
        return this.sqlComment;
    }

    @Override
    public List<ColumnValueParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void forEachParameter(Consumer<ColumnValueParameter> consumer) {
        if (this.parameters == null) {
            return;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            consumer.accept(this.parameters.get(i));
        }
    }

    protected static <T> void forEachThing(List<T> list, BiConsumer<Integer, T> action) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            action.accept(i, (Integer)list.get(i));
        }
    }

    @Override
    public O createMutationOperation(ValuesAnalysis valuesAnalysis, SessionFactoryImplementor factory) {
        SqlAstTranslatorFactory sqlAstTranslatorFactory = factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
        SqlAstTranslator translator = sqlAstTranslatorFactory.buildModelMutationTranslator(this, factory);
        return (O)((MutationOperation)translator.translate(null, MutationQueryOptions.INSTANCE));
    }

    @Override
    public final O createMutationOperation(String sql, List<JdbcParameterBinder> parameterBinders) {
        return this.createMutationOperation(this.getMutatingTable().getTableMapping(), sql, parameterBinders);
    }

    protected abstract O createMutationOperation(TableMapping var1, String var2, List<JdbcParameterBinder> var3);
}

