/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.TimeZone;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterTemporal;
import org.hibernate.type.spi.TypeConfiguration;

public class TimeUtcAsJdbcTimeJdbcType
implements JdbcType {
    public static final TimeUtcAsJdbcTimeJdbcType INSTANCE = new TimeUtcAsJdbcTimeJdbcType();
    private static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    @Override
    public int getJdbcTypeCode() {
        return 92;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3007;
    }

    @Override
    public String getFriendlyName() {
        return "TIME_UTC";
    }

    public String toString() {
        return "TimeUtcDescriptor";
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)OffsetTime.class));
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return OffsetTime.class;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new JdbcLiteralFormatterTemporal<T>(javaType, TemporalType.TIME);
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                OffsetTime offsetTime = javaType.unwrap(value, OffsetTime.class, options);
                st.setTime(index, Time.valueOf(offsetTime.withOffsetSameInstant(ZoneOffset.UTC).toLocalTime()), UTC_CALENDAR);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                OffsetTime offsetTime = javaType.unwrap(value, OffsetTime.class, options);
                st.setTime(name, Time.valueOf(offsetTime.withOffsetSameInstant(ZoneOffset.UTC).toLocalTime()), UTC_CALENDAR);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                Time time = rs.getTime(paramIndex, UTC_CALENDAR);
                return javaType.wrap(time == null ? null : time.toLocalTime().atOffset(ZoneOffset.UTC), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                Time time = statement.getTime(index, UTC_CALENDAR);
                return javaType.wrap(time == null ? null : time.toLocalTime().atOffset(ZoneOffset.UTC), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                Time time = statement.getTime(name, UTC_CALENDAR);
                return javaType.wrap(time == null ? null : time.toLocalTime().atOffset(ZoneOffset.UTC), options);
            }
        };
    }
}

