/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.federation.FederationConnectionConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class FederationConnection {
    private final FederationConnectionConfiguration config;
    private final ServerLocator serverLocator;
    private final long circuitBreakerTimeout;
    private volatile ClientSessionFactory clientSessionFactory;
    private volatile boolean started;
    private volatile boolean sharedConnection;
    private Exception circuitBreakerException;
    private long lastCreateClientSessionFactoryExceptionTimestamp;

    public FederationConnection(Configuration configuration, String name, FederationConnectionConfiguration config) {
        this.config = config;
        this.circuitBreakerTimeout = config.getCircuitBreakerTimeout();
        Map possibleLocatorParameters = null;
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration discoveryGroupConfiguration = configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (discoveryGroupConfiguration == null) {
                ActiveMQServerLogger.LOGGER.bridgeNoDiscoveryGroup(config.getDiscoveryGroupName());
                this.serverLocator = null;
                return;
            }
            this.serverLocator = config.isHA() ? ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)discoveryGroupConfiguration) : ActiveMQClient.createServerLocatorWithoutHA((DiscoveryGroupConfiguration)discoveryGroupConfiguration);
        } else {
            TransportConfiguration[] tcConfigs = configuration.getTransportConfigurations(config.getStaticConnectors());
            if (tcConfigs == null) {
                ActiveMQServerLogger.LOGGER.bridgeCantFindConnectors(name);
                this.serverLocator = null;
                return;
            }
            this.serverLocator = config.isHA() ? ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])tcConfigs) : ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])tcConfigs);
            if (tcConfigs.length > 0) {
                possibleLocatorParameters = tcConfigs[0].getExtraParams();
            }
        }
        if (!config.isHA()) {
            this.serverLocator.setUseTopologyForLoadBalancing(false);
        }
        this.serverLocator.setConnectionTTL(config.getConnectionTTL());
        this.serverLocator.setClientFailureCheckPeriod(config.getClientFailureCheckPeriod());
        this.serverLocator.setReconnectAttempts(config.getReconnectAttempts());
        this.serverLocator.setInitialConnectAttempts(config.getInitialConnectAttempts());
        this.serverLocator.setRetryInterval(config.getRetryInterval());
        this.serverLocator.setRetryIntervalMultiplier(config.getRetryIntervalMultiplier());
        this.serverLocator.setMaxRetryInterval(config.getMaxRetryInterval());
        this.serverLocator.setCallTimeout(config.getCallTimeout());
        this.serverLocator.setCallFailoverTimeout(config.getCallFailoverTimeout());
        if (possibleLocatorParameters != null) {
            try {
                BeanSupport.setData((Object)this.serverLocator, (Map)possibleLocatorParameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void start() {
        this.started = true;
    }

    public synchronized void stop() {
        this.started = false;
        ClientSessionFactory clientSessionFactory = this.clientSessionFactory;
        if (clientSessionFactory != null) {
            clientSessionFactory.cleanup();
            clientSessionFactory.close();
            this.clientSessionFactory = null;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isSharedConnection() {
        return this.sharedConnection;
    }

    public void setSharedConnection(boolean sharedConnection) {
        this.sharedConnection = sharedConnection;
    }

    public final ClientSessionFactory clientSessionFactory() throws Exception {
        ClientSessionFactory clientSessionFactory = this.clientSessionFactory;
        if (this.started) {
            if (clientSessionFactory != null && !clientSessionFactory.isClosed()) {
                return clientSessionFactory;
            }
            return this.circuitBreakerCreateClientSessionFactory();
        }
        throw new ActiveMQSessionCreationException();
    }

    public FederationConnectionConfiguration getConfig() {
        return this.config;
    }

    private synchronized ClientSessionFactory circuitBreakerCreateClientSessionFactory() throws Exception {
        if (this.circuitBreakerTimeout < 0L || this.circuitBreakerException == null || this.lastCreateClientSessionFactoryExceptionTimestamp < System.currentTimeMillis()) {
            try {
                this.circuitBreakerException = null;
                return this.createClientSessionFactory();
            }
            catch (Exception e) {
                this.circuitBreakerException = e;
                this.lastCreateClientSessionFactoryExceptionTimestamp = System.currentTimeMillis() + this.circuitBreakerTimeout;
                throw e;
            }
        }
        throw this.circuitBreakerException;
    }

    private synchronized ClientSessionFactory createClientSessionFactory() throws Exception {
        ClientSessionFactory clientSessionFactory = this.clientSessionFactory;
        if (clientSessionFactory != null && !clientSessionFactory.isClosed()) {
            return clientSessionFactory;
        }
        this.clientSessionFactory = clientSessionFactory = this.serverLocator.createSessionFactory();
        return clientSessionFactory;
    }
}

