/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.reload;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.reload.ReloadCallback;
import org.apache.activemq.artemis.core.server.reload.ReloadManager;
import org.jboss.logging.Logger;

public class ReloadManagerImpl
extends ActiveMQScheduledComponent
implements ReloadManager {
    private static final Logger logger = Logger.getLogger(ReloadManagerImpl.class);
    private volatile Runnable tick;
    private final Map<URL, ReloadRegistry> registry = new HashMap<URL, ReloadRegistry>();

    public ReloadManagerImpl(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod) {
        super(scheduledExecutorService, executor, checkPeriod, TimeUnit.MILLISECONDS, false);
    }

    public void run() {
        this.tick();
    }

    @Override
    public synchronized void setTick(Runnable tick) {
        this.tick = tick;
    }

    @Override
    public synchronized void addCallback(URL uri, ReloadCallback callback) {
        if (!this.isStarted()) {
            this.start();
        }
        ReloadRegistry uriRegistry = this.getRegistry(uri);
        uriRegistry.add(callback);
    }

    private synchronized void tick() {
        for (ReloadRegistry item : this.registry.values()) {
            item.check();
        }
        if (this.tick != null) {
            this.tick.run();
            this.tick = null;
        }
    }

    private ReloadRegistry getRegistry(URL uri) {
        ReloadRegistry uriRegistry = this.registry.get(uri);
        if (uriRegistry == null) {
            uriRegistry = new ReloadRegistry(uri);
            this.registry.put(uri, uriRegistry);
        }
        return uriRegistry;
    }

    class ReloadRegistry {
        private File file;
        private final URL uri;
        private long lastModified;
        private final List<ReloadCallback> callbacks = new LinkedList<ReloadCallback>();

        ReloadRegistry(URL uri) {
            try {
                this.file = new File(uri.toURI());
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
                this.file = new File(uri.getPath());
            }
            if (!this.file.exists()) {
                ActiveMQServerLogger.LOGGER.fileDoesNotExist(this.file.toString());
            }
            this.lastModified = this.file.lastModified();
            this.uri = uri;
        }

        public void check() {
            long fileModified = this.file.lastModified();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Validating lastModified " + this.lastModified + " modified = " + fileModified + " on " + this.uri));
            }
            if (this.lastModified > 0L && fileModified > this.lastModified || fileModified > 0L && this.lastModified == 0L) {
                for (ReloadCallback callback : this.callbacks) {
                    try {
                        callback.reload(this.uri);
                    }
                    catch (Throwable e) {
                        ActiveMQServerLogger.LOGGER.configurationReloadFailed(e);
                    }
                }
            }
            this.lastModified = fileModified;
        }

        public List<ReloadCallback> getCallbacks() {
            return this.callbacks;
        }

        public void add(ReloadCallback callback) {
            this.callbacks.add(callback);
        }
    }
}

