/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Set;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.Query;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.search.mapper.orm.loading.impl.ConditionalExpressionQueryFactory;

class HqlTypeQueryFactory<E, I>
extends ConditionalExpressionQueryFactory<E, I> {
    private final EntityMappingType entityMappingType;

    HqlTypeQueryFactory(EntityMappingType entityMappingType, String uniquePropertyName) {
        super(uniquePropertyName.equals(entityMappingType.getIdentifierMapping().getAttributeName()) ? entityMappingType.getIdentifierMapping().getJavaType().getJavaTypeClass() : entityMappingType.findAttributeMapping(uniquePropertyName).getJavaType().getJavaTypeClass(), uniquePropertyName);
        this.entityMappingType = entityMappingType;
    }

    @Override
    public Query<Long> createQueryForCount(SharedSessionContractImplementor session, Set<? extends Class<? extends E>> includedTypesFilter) {
        return this.createQueryWithTypesFilter(session, "select count(e) from " + this.entityMappingType.getEntityName() + " e", Long.class, "e", includedTypesFilter);
    }

    @Override
    public Query<I> createQueryForIdentifierListing(SharedSessionContractImplementor session, Set<? extends Class<? extends E>> includedTypesFilter) {
        return this.createQueryWithTypesFilter(session, "select e. " + this.uniquePropertyName + " from " + this.entityMappingType.getEntityName() + " e", this.uniquePropertyType, "e", includedTypesFilter);
    }

    @Override
    public Query<E> createQueryForLoadByUniqueProperty(SessionImplementor session, String parameterName) {
        return session.createQuery("select e from " + this.entityMappingType.getEntityName() + " e where " + this.uniquePropertyName + " in (:" + parameterName + ")", this.entityMappingType.getMappedJavaType().getJavaTypeClass());
    }

    @Override
    public MultiIdentifierLoadAccess<E> createMultiIdentifierLoadAccess(SessionImplementor session) {
        return session.byMultipleIds(this.entityMappingType.getEntityName());
    }

    @Override
    public boolean uniquePropertyIsTheEntityId() {
        return this.uniquePropertyName.equals(this.entityMappingType.getIdentifierMapping().getAttributeName());
    }

    private <T> Query<T> createQueryWithTypesFilter(SharedSessionContractImplementor session, String hql, Class<T> returnedType, String entityAlias, Set<? extends Class<? extends E>> includedTypesFilter) {
        if (!includedTypesFilter.isEmpty()) {
            hql = hql + " where type(" + entityAlias + ") in (:types)";
        }
        QueryImplementor query = session.createQuery(hql, returnedType);
        if (!includedTypesFilter.isEmpty()) {
            query.setParameterList("types", includedTypesFilter);
        }
        return query;
    }
}

