/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client.internal.proxy.nonjaxrs;

import io.narayana.lra.logging.LRALogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.Resource;

class ClassPathIndexer {
    private static final Logger log = Logger.getLogger(ClassPathIndexer.class);

    ClassPathIndexer() {
    }

    Index createIndex() throws IOException {
        Indexer indexer = new Indexer();
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        List<URL> urls = cl instanceof URLClassLoader ? new ArrayList<URL>(Arrays.asList(((URLClassLoader)cl).getURLs())) : this.collectURLsFromClassPath();
        for (URL url : urls) {
            this.processFile(url.openStream(), indexer);
        }
        this.tryToIndexContextModuleClassLoader(indexer);
        return indexer.complete();
    }

    private List<URL> collectURLsFromClassPath() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String s : System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
            if (!s.endsWith(".jar")) continue;
            try {
                urls.add(new File(s).toURI().toURL());
            }
            catch (MalformedURLException e) {
                LRALogger.logger.warn((Object)"Cannot create URL from a JAR file included in the classpath", (Throwable)e);
            }
        }
        return urls;
    }

    private void processFile(InputStream inputStream, Indexer indexer) throws IOException {
        ZipInputStream zis = new ZipInputStream(inputStream, StandardCharsets.UTF_8);
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            String entryName = ze.getName();
            if (!entryName.endsWith(".class")) continue;
            indexer.index((InputStream)zis);
        }
    }

    private void tryToIndexContextModuleClassLoader(Indexer indexer) throws IOException {
        try {
            this.getClass();
            Class.forName("org.jboss.modules.ModuleClassLoader");
        }
        catch (ClassNotFoundException cnfe) {
            log.debug((Object)"Cannot load class 'org.jboss.modules.ModuleClassLoader' to index resources", (Throwable)cnfe);
            return;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader instanceof ModuleClassLoader) {
            Iterator resources = ((ModuleClassLoader)currentThreadClassLoader).iterateResources("", true);
            while (resources.hasNext()) {
                Resource resource = (Resource)resources.next();
                if (!resource.getURL().getFile().endsWith("class")) continue;
                try (InputStream is = resource.openStream();){
                    indexer.index(resource.openStream());
                }
            }
        }
    }
}

