/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.wildfly.openssl.DefaultByteBufferPool;
import org.wildfly.openssl.Messages;
import org.wildfly.openssl.OpenSSLEngine;
import org.wildfly.openssl.OpenSSLInputStream;
import org.wildfly.openssl.OpenSSLOutputStream;

public class OpenSSLSocket
extends SSLSocket {
    private static final Logger logger = Logger.getLogger(OpenSSLSocket.class.getName());
    private final OpenSSLEngine sslEngine;
    private final List<HandshakeCompletedListener> handshakeCompletedListenerList = new ArrayList<HandshakeCompletedListener>();
    private final OpenSSLOutputStream sslOut;
    private final OpenSSLInputStream sslIn;
    private static final ByteBuffer EMPTY_DIRECT = ByteBuffer.allocateDirect(0);
    private DefaultByteBufferPool.PooledByteBuffer unwrappedData;
    private DefaultByteBufferPool.PooledByteBuffer dataToUnwrap;
    private boolean handshakeDone = false;
    private final Socket delegate;
    private final boolean autoclose;

    protected OpenSSLSocket(OpenSSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = null;
        this.autoclose = true;
    }

    protected OpenSSLSocket(String host, int port, OpenSSLEngine sslEngine) throws IOException {
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = null;
        this.autoclose = true;
        sslEngine.setHost(host);
        sslEngine.setPort(port);
        this.connect(new InetSocketAddress(host, port));
    }

    protected OpenSSLSocket(InetAddress address, int port, OpenSSLEngine sslEngine) throws IOException {
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = null;
        this.autoclose = true;
        sslEngine.setHost(address.getHostName());
        sslEngine.setPort(port);
        this.connect(new InetSocketAddress(address, port));
    }

    protected OpenSSLSocket(String host, int port, InetAddress clientAddress, int clientPort, OpenSSLEngine sslEngine) throws IOException {
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = null;
        this.autoclose = true;
        sslEngine.setHost(host);
        sslEngine.setPort(port);
        this.bind(new InetSocketAddress(clientAddress, clientPort));
        this.connect(new InetSocketAddress(host, port));
    }

    protected OpenSSLSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort, OpenSSLEngine sslEngine) throws IOException {
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = null;
        this.autoclose = true;
        sslEngine.setHost(address.getHostName());
        sslEngine.setPort(port);
        this.bind(new InetSocketAddress(clientAddress, clientPort));
        this.connect(new InetSocketAddress(address, port));
    }

    protected OpenSSLSocket(Socket socket, boolean autoclose, OpenSSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = socket;
        this.autoclose = autoclose;
    }

    protected OpenSSLSocket(Socket socket, boolean autoclose, String host, int port, OpenSSLEngine sslEngine) throws IOException {
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = socket;
        this.autoclose = autoclose;
        sslEngine.setHost(host);
        sslEngine.setPort(port);
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.sslEngine.getHandshakeSession();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.sslEngine.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.sslEngine.setSSLParameters(params);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.sslIn;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.sslOut;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslEngine.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslEngine.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.sslEngine.setEnabledCipherSuites(suites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.sslEngine.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslEngine.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.sslEngine.setEnabledProtocols(protocols);
    }

    @Override
    public SSLSession getSession() {
        if (this.sslEngine.isHandshakeFinished() || this.sslEngine.isOutboundDone() || this.sslEngine.isInboundDone()) {
            return this.sslEngine.getSession();
        }
        try {
            this.startHandshake();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, Messages.MESSAGES.handshakeFailed(), e);
        }
        return this.sslEngine.getSession();
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.handshakeCompletedListenerList.add(listener);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.handshakeCompletedListenerList.remove(listener);
    }

    @Override
    public void startHandshake() throws IOException {
        this.handshakeDone = false;
        this.sslEngine.beginHandshake();
        this.runHandshake();
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.sslEngine.setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslEngine.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslEngine.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslEngine.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslEngine.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslEngine.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.sslEngine.setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslEngine.getEnableSessionCreation();
    }

    private void invokeHandshakeListeners() {
        HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.getSession());
        for (HandshakeCompletedListener listener : new ArrayList<HandshakeCompletedListener>(this.handshakeCompletedListenerList)) {
            listener.handshakeCompleted(event);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.unwrappedData != null) {
            this.unwrappedData.close();
            this.unwrappedData = null;
        }
        if (this.dataToUnwrap != null) {
            this.dataToUnwrap.close();
            this.dataToUnwrap = null;
        }
        if (this.delegate == null) {
            super.close();
        } else if (this.autoclose) {
            this.delegate.close();
        }
        this.sslEngine.shutdown();
    }

    /*
     * Exception decompiling
     */
    private void runHandshake() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[UNCONDITIONALDOLOOP]], but top level block is 29[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream getDelegateInputStream() throws IOException {
        if (this.delegate == null) {
            return super.getInputStream();
        }
        return this.delegate.getInputStream();
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int numRead = this.read(b);
        return numRead == -1 ? -1 : b[0] & 0xFF;
    }

    /*
     * Exception decompiling
     */
    public int read(byte[] b, int off, int len) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)(b & 0xFF)};
        this.write(data);
    }

    public void flush() throws IOException {
        this.getDelegateOutputStream().flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.runHandshake();
        try (DefaultByteBufferPool.PooledByteBuffer uncompressedPooled = DefaultByteBufferPool.WRITE_DIRECT_POOL.allocate();
             DefaultByteBufferPool.PooledByteBuffer encryptedPooled = DefaultByteBufferPool.HEAP_POOL.allocate();){
            ByteBuffer buf = uncompressedPooled.getBuffer();
            int toWrite = len;
            int written = 0;
            while (toWrite > 0) {
                buf.clear();
                int thisBufferAmount = Math.min(toWrite, buf.remaining());
                buf.put(b, off + written, thisBufferAmount);
                toWrite -= thisBufferAmount;
                written += thisBufferAmount;
                buf.flip();
                while (buf.hasRemaining()) {
                    encryptedPooled.getBuffer().clear();
                    SSLEngineResult result = this.sslEngine.wrap(buf, encryptedPooled.getBuffer());
                    encryptedPooled.getBuffer().flip();
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        this.close();
                        throw new IOException(Messages.MESSAGES.bufferOverflow());
                    }
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        this.close();
                        throw new IOException(Messages.MESSAGES.bufferUnderflow());
                    }
                    if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                        this.close();
                        throw new IOException(Messages.MESSAGES.streamIsClosed());
                    }
                    int produced = result.bytesProduced();
                    if (produced <= 0) continue;
                    this.getDelegateOutputStream().write(encryptedPooled.getBuffer().array(), encryptedPooled.getBuffer().arrayOffset(), encryptedPooled.getBuffer().remaining());
                }
            }
        }
    }

    private OutputStream getDelegateOutputStream() throws IOException {
        if (this.delegate == null) {
            return super.getOutputStream();
        }
        return this.delegate.getOutputStream();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        if (this.delegate == null) {
            super.connect(endpoint);
        } else {
            this.delegate.connect(endpoint);
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException(Messages.MESSAGES.unsupportedAddressType());
        }
        InetSocketAddress address = (InetSocketAddress)endpoint;
        this.sslEngine.setHost(address.getHostName());
        this.sslEngine.setPort(address.getPort());
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.delegate == null) {
            super.connect(endpoint, timeout);
        } else {
            this.delegate.connect(endpoint, timeout);
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException(Messages.MESSAGES.unsupportedAddressType());
        }
        InetSocketAddress address = (InetSocketAddress)endpoint;
        this.sslEngine.setHost(address.getHostName());
        this.sslEngine.setPort(address.getPort());
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.delegate == null) {
            super.bind(bindpoint);
        } else {
            this.delegate.bind(bindpoint);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.delegate == null) {
            return super.getInetAddress();
        }
        return this.delegate.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.delegate == null) {
            return super.getLocalAddress();
        }
        return this.delegate.getLocalAddress();
    }

    @Override
    public int getPort() {
        if (this.delegate == null) {
            return super.getPort();
        }
        return this.delegate.getPort();
    }

    @Override
    public int getLocalPort() {
        if (this.delegate == null) {
            return super.getLocalPort();
        }
        return this.delegate.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (this.delegate == null) {
            return super.getRemoteSocketAddress();
        }
        return this.delegate.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        if (this.delegate == null) {
            return super.getLocalSocketAddress();
        }
        return this.delegate.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        if (this.delegate == null) {
            return super.getChannel();
        }
        return this.delegate.getChannel();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.delegate == null) {
            super.setTcpNoDelay(on);
        } else {
            this.delegate.setTcpNoDelay(on);
        }
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        if (this.delegate == null) {
            return super.getTcpNoDelay();
        }
        return this.delegate.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.delegate == null) {
            super.setSoLinger(on, linger);
        } else {
            this.delegate.setSoLinger(on, linger);
        }
    }

    @Override
    public int getSoLinger() throws SocketException {
        if (this.delegate == null) {
            return super.getSoLinger();
        }
        return this.delegate.getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        if (this.delegate == null) {
            super.sendUrgentData(data);
        } else {
            this.delegate.sendUrgentData(data);
        }
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        if (this.delegate == null) {
            super.setOOBInline(on);
        } else {
            this.delegate.setOOBInline(on);
        }
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        if (this.delegate == null) {
            return super.getOOBInline();
        }
        return this.delegate.getOOBInline();
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.delegate == null) {
            super.setSoTimeout(timeout);
        } else {
            this.delegate.setSoTimeout(timeout);
        }
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        if (this.delegate == null) {
            return super.getSoTimeout();
        }
        return this.delegate.getSoTimeout();
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (this.delegate == null) {
            super.setSendBufferSize(size);
        } else {
            this.delegate.setSendBufferSize(size);
        }
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        if (this.delegate == null) {
            return super.getSendBufferSize();
        }
        return this.delegate.getSendBufferSize();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (this.delegate == null) {
            super.setReceiveBufferSize(size);
        } else {
            this.delegate.setReceiveBufferSize(size);
        }
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.delegate == null) {
            return super.getReceiveBufferSize();
        }
        return this.delegate.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        if (this.delegate == null) {
            super.setKeepAlive(on);
        } else {
            this.delegate.setKeepAlive(on);
        }
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        if (this.delegate == null) {
            return super.getKeepAlive();
        }
        return this.delegate.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        if (this.delegate == null) {
            super.setTrafficClass(tc);
        } else {
            this.delegate.setTrafficClass(tc);
        }
    }

    @Override
    public int getTrafficClass() throws SocketException {
        if (this.delegate == null) {
            return super.getTrafficClass();
        }
        return this.delegate.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        if (this.delegate == null) {
            super.setReuseAddress(on);
        } else {
            this.delegate.setReuseAddress(on);
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        if (this.delegate == null) {
            return super.getReuseAddress();
        }
        return this.delegate.getReuseAddress();
    }

    @Override
    public void shutdownInput() throws IOException {
        if (this.delegate == null) {
            super.shutdownInput();
        } else {
            this.delegate.shutdownInput();
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (this.delegate == null) {
            super.shutdownOutput();
        } else {
            this.delegate.shutdownOutput();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " ]engine state: " + this.sslEngine + "]";
    }

    @Override
    public boolean isConnected() {
        if (this.delegate == null) {
            return super.isConnected();
        }
        return this.delegate.isConnected();
    }

    @Override
    public boolean isBound() {
        if (this.delegate == null) {
            return super.isBound();
        }
        return this.delegate.isBound();
    }

    @Override
    public boolean isClosed() {
        if (this.delegate == null) {
            return super.isClosed();
        }
        return this.delegate.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        if (this.delegate == null) {
            return super.isInputShutdown();
        }
        return this.delegate.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        if (this.delegate == null) {
            return super.isOutputShutdown();
        }
        return this.delegate.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        if (this.delegate == null) {
            super.setPerformancePreferences(connectionTime, latency, bandwidth);
        } else {
            this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
        }
    }

    public String getSelectedApplicationProtocol() {
        return this.sslEngine.getSelectedApplicationProtocol();
    }

    public String[] getApplicationProtocols() {
        return this.sslEngine.getApplicationProtocols();
    }

    public void setApplicationProtocols(String ... applicationProtocols) {
        this.sslEngine.setApplicationProtocols(applicationProtocols);
    }
}

