/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.impl.AbstractPojoTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContext;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContextProvider;
import org.hibernate.search.util.common.data.spi.KeyValueProvider;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoTypeManagerContainer
implements AutoCloseable,
PojoWorkTypeContextProvider,
PojoScopeTypeContextProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, AbstractPojoTypeManager<?, ?>> byExactType;
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, PojoIndexedTypeManager<?, ?>> indexedByExactType;
    private final KeyValueProvider<String, AbstractPojoTypeManager<?, ?>> byEntityName;
    private final KeyValueProvider<String, PojoRawTypeIdentifier<?>> typeIdentifierByEntityName;
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, Set<? extends AbstractPojoTypeManager<?, ?>>> allByNonInterfaceSuperType;
    private final Map<PojoRawTypeIdentifier<?>, Set<? extends PojoIndexedTypeManager<?, ?>>> indexedBySuperType;
    private final Collection<PojoIndexedTypeManager<?, ?>> allIndexed;
    private final Set<PojoRawTypeIdentifier<?>> allIndexedAndContainedTypes;
    private final Set<PojoRawTypeIdentifier<?>> allNonInterfaceSuperTypes;
    private final Set<Class<?>> allNonInterfaceSuperTypesClasses;

    public static Builder builder() {
        return new Builder();
    }

    private PojoTypeManagerContainer(Builder builder) {
        PojoRawTypeIdentifier typeIdentifier;
        LinkedHashMap<PojoRawTypeIdentifier, AbstractPojoTypeManager> byExactTypeContent = new LinkedHashMap<PojoRawTypeIdentifier, AbstractPojoTypeManager>();
        LinkedHashMap<PojoRawTypeIdentifier, PojoIndexedTypeManager> indexedByExactTypeContent = new LinkedHashMap<PojoRawTypeIdentifier, PojoIndexedTypeManager>();
        LinkedHashMap<String, AbstractPojoTypeManager> byEntityNameContent = new LinkedHashMap<String, AbstractPojoTypeManager>();
        LinkedHashMap typeIdentifierByEntityNameContent = new LinkedHashMap();
        HashSet allNonInterfaceSuperTypesClassesContent = new HashSet();
        for (PojoIndexedTypeManager pojoIndexedTypeManager : builder.indexed) {
            typeIdentifier = pojoIndexedTypeManager.typeIdentifier;
            byExactTypeContent.put(typeIdentifier, pojoIndexedTypeManager);
            indexedByExactTypeContent.put(typeIdentifier, pojoIndexedTypeManager);
            byEntityNameContent.put(pojoIndexedTypeManager.entityName(), pojoIndexedTypeManager);
        }
        for (PojoContainedTypeManager pojoContainedTypeManager : builder.contained) {
            typeIdentifier = pojoContainedTypeManager.typeIdentifier;
            byExactTypeContent.put(typeIdentifier, pojoContainedTypeManager);
            byEntityNameContent.put(pojoContainedTypeManager.entityName(), pojoContainedTypeManager);
        }
        for (PojoRawTypeIdentifier pojoRawTypeIdentifier : builder.allByNonInterfaceSuperType.keySet()) {
            if (pojoRawTypeIdentifier.javaClass().isInterface()) continue;
            allNonInterfaceSuperTypesClassesContent.add(pojoRawTypeIdentifier.javaClass());
        }
        for (Map.Entry entry : builder.allEntitiesByName.entrySet()) {
            PojoRawTypeIdentifier typedIdentifier = ((PojoRawTypeModel)entry.getValue()).typeIdentifier();
            if (!builder.allByNonInterfaceSuperType.containsKey(typedIdentifier)) continue;
            typeIdentifierByEntityNameContent.put((String)entry.getKey(), typedIdentifier);
        }
        this.byExactType = new KeyValueProvider(byExactTypeContent, log::unknownTypeIdentifierForMappedEntityType);
        this.indexedByExactType = new KeyValueProvider(indexedByExactTypeContent, log::unknownTypeIdentifierForIndexedEntityType);
        this.byEntityName = new KeyValueProvider(byEntityNameContent, log::unknownEntityNameForMappedEntityType);
        this.typeIdentifierByEntityName = new KeyValueProvider(typeIdentifierByEntityNameContent, log::unknownEntityNameForAnyEntityByName);
        builder.allByNonInterfaceSuperType.replaceAll((k, v) -> Collections.unmodifiableSet(v));
        this.allByNonInterfaceSuperType = new KeyValueProvider(builder.allByNonInterfaceSuperType, log::unknownSupertypeTypeIdentifier);
        this.allNonInterfaceSuperTypes = Collections.unmodifiableSet(builder.allByNonInterfaceSuperType.keySet());
        this.indexedBySuperType = new LinkedHashMap(builder.indexedBySuperType);
        this.indexedBySuperType.replaceAll((k, v) -> Collections.unmodifiableSet(v));
        this.allIndexed = Collections.unmodifiableCollection(indexedByExactTypeContent.values());
        this.allIndexedAndContainedTypes = Collections.unmodifiableSet(byExactTypeContent.keySet());
        this.allNonInterfaceSuperTypesClasses = Collections.unmodifiableSet(allNonInterfaceSuperTypesClassesContent);
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(AbstractPojoTypeManager::close, this.allIndexed);
        }
    }

    public <E> AbstractPojoTypeManager<?, E> forExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (AbstractPojoTypeManager)this.byExactType.getOrFail(typeIdentifier);
    }

    public <E> PojoIndexedTypeManager<?, E> indexedForExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (PojoIndexedTypeManager)this.indexedByExactType.getOrFail(typeIdentifier);
    }

    @Override
    public Set<PojoRawTypeIdentifier<?>> allIndexedSuperTypes() {
        return this.indexedBySuperType.keySet();
    }

    @Override
    public Set<PojoRawTypeIdentifier<?>> allNonInterfaceSuperTypes() {
        return this.allNonInterfaceSuperTypes;
    }

    @Override
    public Set<Class<?>> allNonInterfaceSuperTypesClasses() {
        return this.allNonInterfaceSuperTypesClasses;
    }

    @Override
    public Set<PojoRawTypeIdentifier<?>> allIndexedAndContainedTypes() {
        return this.allIndexedAndContainedTypes;
    }

    @Override
    public <E> Optional<? extends Set<? extends PojoScopeIndexedTypeContext<?, ? extends E>>> allIndexedForSuperType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return Optional.ofNullable(this.indexedBySuperType.get(typeIdentifier));
    }

    @Override
    public <E> Set<? extends PojoWorkTypeContext<?, ? extends E>> allByNonInterfaceSuperType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (Set)this.allByNonInterfaceSuperType.getOrFail(typeIdentifier);
    }

    @Override
    public KeyValueProvider<String, ? extends PojoWorkTypeContext<?, ?>> byEntityName() {
        return this.byEntityName;
    }

    @Override
    public KeyValueProvider<String, PojoRawTypeIdentifier<?>> typeIdentifierByEntityName() {
        return this.typeIdentifierByEntityName;
    }

    Collection<PojoIndexedTypeManager<?, ?>> allIndexed() {
        return this.allIndexed;
    }

    public static class Builder {
        private final List<PojoIndexedTypeManager<?, ?>> indexed = new ArrayList();
        private final List<PojoContainedTypeManager<?, ?>> contained = new ArrayList();
        private final Map<PojoRawTypeIdentifier<?>, Set<PojoIndexedTypeManager<?, ?>>> indexedBySuperType = new LinkedHashMap();
        private final Map<PojoRawTypeIdentifier<?>, Set<AbstractPojoTypeManager<?, ?>>> allByNonInterfaceSuperType = new LinkedHashMap();
        private final Map<String, PojoRawTypeModel<?>> allEntitiesByName = new LinkedHashMap();

        private Builder() {
        }

        public <E> void addIndexed(PojoRawTypeModel<E> typeModel, PojoIndexedTypeManager<?, E> typeManager) {
            this.indexed.add(typeManager);
            typeModel.descendingSuperTypes().map(PojoRawTypeModel::typeIdentifier).forEach(clazz -> {
                this.indexedBySuperType.computeIfAbsent((PojoRawTypeIdentifier<?>)clazz, ignored -> new LinkedHashSet()).add(typeManager);
                if (clazz.isNamed() || !clazz.javaClass().isInterface()) {
                    this.allByNonInterfaceSuperType.computeIfAbsent((PojoRawTypeIdentifier<?>)clazz, ignored -> new LinkedHashSet()).add(typeManager);
                }
            });
        }

        public <E> void addContained(PojoRawTypeModel<E> typeModel, PojoContainedTypeManager<?, E> typeManager) {
            this.contained.add(typeManager);
            typeModel.descendingSuperTypes().map(PojoRawTypeModel::typeIdentifier).filter(clazz -> clazz.isNamed() || !clazz.javaClass().isInterface()).forEach(clazz -> this.allByNonInterfaceSuperType.computeIfAbsent((PojoRawTypeIdentifier<?>)clazz, ignored -> new LinkedHashSet()).add(typeManager));
        }

        public void addEntity(String entityName, PojoRawTypeModel<?> entityType) {
            this.allEntitiesByName.put(entityName, entityType);
        }

        public void closeOnFailure() {
            try (Closer closer = new Closer();){
                closer.pushAll(PojoIndexedTypeManager::close, this.indexed);
                closer.pushAll(AbstractPojoTypeManager::close, this.contained);
            }
        }

        public PojoTypeManagerContainer build() {
            return new PojoTypeManagerContainer(this);
        }
    }
}

