/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.hcann.spi;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoHCAnnConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoMethodParameterModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class PojoHCAnnMethodParameterModel<T>
implements PojoMethodParameterModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoHCAnnConstructorModel<?> constructorModel;
    private final int index;
    private final Parameter parameter;
    private final AnnotatedType annotatedType;
    private Annotation[] annotations;
    private PojoTypeModel<T> typeModelCache;

    public PojoHCAnnMethodParameterModel(PojoHCAnnConstructorModel<?> constructorModel, int index, Parameter parameter, AnnotatedType annotatedType, Annotation[] annotationsForJDK8303112) {
        this.constructorModel = constructorModel;
        this.index = index;
        this.parameter = parameter;
        this.annotatedType = annotatedType;
        this.annotations = annotationsForJDK8303112;
    }

    public String toString() {
        return "parameter #" + this.index + "(" + this.name().orElse("<unknown name>") + ")";
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public Optional<String> name() {
        return this.parameter.isNamePresent() ? Optional.of(this.parameter.getName()) : Optional.empty();
    }

    @Override
    public Stream<Annotation> annotations() {
        if (this.annotations == null) {
            this.annotations = this.parameter.getAnnotations();
        }
        return Arrays.stream(this.annotations);
    }

    @Override
    public PojoTypeModel<T> typeModel() {
        if (this.typeModelCache == null) {
            try {
                this.typeModelCache = this.constructorModel.declaringTypeModel.rawTypeDeclaringContext.memberTypeReference(this.annotatedType.getType());
            }
            catch (RuntimeException e) {
                throw log.errorRetrievingConstructorParameterTypeModel(this.index, this.constructorModel, e);
            }
        }
        return this.typeModelCache;
    }

    @Override
    public boolean isEnclosingInstance() {
        return this.index == 0 && this.constructorModel.declaringTypeModel.javaClass().getEnclosingClass() != null && !Modifier.isStatic(this.constructorModel.declaringTypeModel.javaClass().getModifiers());
    }
}

