/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.impl;

import java.util.Objects;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoMethodParameterModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.util.common.reporting.EventContext;

final class PojoConstructorParameterProjectionMappingElement
implements MappingElement {
    private final PojoRawTypeIdentifier<?> declaringProjectionConstructorType;
    private final PojoMethodParameterModel<?> declaringParameter;
    private final ProjectionBinder binder;

    public PojoConstructorParameterProjectionMappingElement(PojoConstructorModel<?> declaringProjectionConstructor, PojoMethodParameterModel<?> declaringParameter, ProjectionBinder binder) {
        this.declaringProjectionConstructorType = declaringProjectionConstructor.typeModel().typeIdentifier();
        this.declaringParameter = declaringParameter;
        this.binder = binder;
    }

    public String toString() {
        return this.binder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoConstructorParameterProjectionMappingElement that = (PojoConstructorParameterProjectionMappingElement)o;
        return Objects.equals(this.declaringProjectionConstructorType, that.declaringProjectionConstructorType) && Objects.equals(this.declaringParameter, that.declaringParameter);
    }

    public int hashCode() {
        return Objects.hash(this.declaringProjectionConstructorType, this.declaringParameter);
    }

    public EventContext eventContext() {
        return PojoEventContexts.fromType(this.declaringProjectionConstructorType).append(PojoEventContexts.projectionConstructor()).append(PojoEventContexts.fromMethodParameter(this.declaringParameter));
    }
}

