/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.core.Ids;

public class ClassExternalizer
implements AdvancedExternalizer<Class> {
    private final ClassLoader cl;

    public ClassExternalizer(ClassLoader cl) {
        this.cl = cl;
    }

    public Set<Class<? extends Class>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{Class.class});
    }

    public Integer getId() {
        return Ids.CLASS;
    }

    public void writeObject(ObjectOutput out, Class o) throws IOException {
        out.writeUTF(o.getName());
    }

    public Class readObject(ObjectInput in) throws IOException, ClassNotFoundException {
        return Class.forName(in.readUTF(), true, this.cl);
    }
}

