/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.pushdpopd;

import java.util.ArrayList;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.converter.FileResourceConverter;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;

@CommandDefinition(name="pushd", description="usage: pushd [dir]")
public class Pushd
implements Command<CommandInvocation> {
    @Option(shortName=104, hasValue=false)
    private boolean help;
    @Arguments(completer=FileOptionCompleter.class, converter=FileResourceConverter.class)
    private List<Resource> arguments;
    private List<Resource> directories = new ArrayList<Resource>();

    public CommandResult execute(CommandInvocation commandInvocation) throws InterruptedException {
        if (this.help) {
            commandInvocation.getShell().writeln(commandInvocation.getHelpInfo("pushd"));
            return CommandResult.SUCCESS;
        }
        if (this.arguments != null && this.arguments.size() > 0) {
            List files = this.arguments.get(0).resolve(commandInvocation.getConfiguration().getAeshContext().getCurrentWorkingDirectory());
            if (((Resource)files.get(0)).isDirectory()) {
                Resource oldCwd = commandInvocation.getConfiguration().getAeshContext().getCurrentWorkingDirectory();
                this.directories.add(oldCwd);
                commandInvocation.getConfiguration().getAeshContext().setCurrentWorkingDirectory((Resource)files.get(0));
                commandInvocation.getShell().writeln(files.get(0) + " " + this.getDirectoriesAsString());
                return CommandResult.SUCCESS;
            }
            return CommandResult.FAILURE;
        }
        commandInvocation.getShell().writeln("pushd: no other directory");
        return CommandResult.FAILURE;
    }

    private String getDirectoriesAsString() {
        StringBuilder builder = new StringBuilder();
        for (Resource f : this.directories) {
            if (builder.length() > 0) {
                builder.insert(0, " ");
            }
            builder.insert(0, f.toString());
        }
        return builder.toString();
    }

    public Resource popDirectory() {
        if (this.directories.size() > 0) {
            return this.directories.remove(this.directories.size() - 1);
        }
        return null;
    }
}

